/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.ml.cluster;

import java.util.Comparator;
import java.util.List;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.ml.clustering.Clusterable;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.ml.cluster.CompositeSegmentClusterer;
import org.thingsboard.trendz.ml.cluster.CustomDistanceClusterer;
import org.thingsboard.trendz.ml.cluster.DBScanClusterer;
import org.thingsboard.trendz.ml.cluster.KMeansClusterer;
import org.thingsboard.trendz.ml.cluster.SegmentClusterer;
import org.thingsboard.trendz.ml.domain.ClusterableSegment;
import org.thingsboard.trendz.ml.domain.MlProperties;
import org.thingsboard.trendz.ml.domain.Segment;
import org.thingsboard.trendz.ml.util.MlUtil;

@Component
public class CompositeSegmentClusterer {
    private static final Logger log = LoggerFactory.getLogger(CompositeSegmentClusterer.class);
    @Autowired
    private DBScanClusterer dbScanClusterer;
    @Autowired
    private KMeansClusterer kMeansClusterer;
    @Autowired
    private CustomDistanceClusterer customDistanceClusterer;

    public List<CentroidCluster<ClusterableSegment>> cluster(List<Segment> segments, MlProperties.ClusteringProperties properties) {
        DistanceMeasure measure = this.getMeasure(properties);
        SegmentClusterer clusterer = this.getClusterer(properties);
        List centroids = clusterer.cluster(segments, measure, properties);
        centroids.sort(Comparator.comparingInt(o -> o.getPoints().size()));
        log.info("detected centriods {}", (Object)centroids.size());
        for (int i = 0; i < centroids.size(); ++i) {
            CentroidCluster cluster = (CentroidCluster)centroids.get(i);
            Clusterable center = cluster.getCenter();
            List clusterRecords = cluster.getPoints();
            log.info("Cluster {} size {}", (Object)i, (Object)clusterRecords.size());
        }
        return centroids;
    }

    private SegmentClusterer getClusterer(MlProperties.ClusteringProperties properties) {
        switch (1.$SwitchMap$org$thingsboard$trendz$ml$domain$MlProperties$ClusterAlgorithm[properties.getClusterAlgorithm().ordinal()]) {
            case 1: {
                return this.customDistanceClusterer;
            }
            case 2: {
                return this.kMeansClusterer;
            }
            case 3: {
                return this.dbScanClusterer;
            }
        }
        throw new IllegalStateException("Distance function not supported " + properties.getClusterAlgorithm());
    }

    private DistanceMeasure getMeasure(MlProperties.ClusteringProperties properties) {
        return MlUtil.getMeasure((MlProperties.DistanceFunctionType)properties.getClusterLearnDistFunc());
    }
}

