/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.ml.cluster;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.random.EmpiricalDistribution;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.dao.sql.TimeStampUUIDGenerator;
import org.thingsboard.trendz.ml.domain.Anomaly;
import org.thingsboard.trendz.ml.domain.ClusterInfo;
import org.thingsboard.trendz.ml.domain.ClusterableSegment;
import org.thingsboard.trendz.ml.domain.ScoredPoint;

@Component
public class ClusterInfoBuilder {
    private static final Logger log = LoggerFactory.getLogger(ClusterInfoBuilder.class);

    public List<ClusterInfo> build(List<CentroidCluster<ClusterableSegment>> centroids, List<Anomaly> anomalies) {
        ArrayList result = Lists.newArrayList();
        HashSet clusterIds = new HashSet();
        long clusterId = 0L;
        for (CentroidCluster<ClusterableSegment> centroid : centroids) {
            ClusterInfo info = new ClusterInfo();
            info.setClusterId(++clusterId);
            long finalClusterId = clusterId;
            List clusterAnomalies = anomalies.stream().filter(a -> a.getClusterId() == finalClusterId).collect(Collectors.toList());
            info.setSegmentsCount(clusterAnomalies.size());
            info.setSegmentsPercent(anomalies.size() > 0 ? clusterAnomalies.size() * 100 / anomalies.size() : 0);
            long duration = clusterAnomalies.stream().mapToLong(a -> a.getEndTs() - a.getStartTs()).sum();
            info.setDurationMs(duration);
            double minScore = clusterAnomalies.stream().mapToDouble(Anomaly::getScore).min().orElse(0.0);
            double maxScore = clusterAnomalies.stream().mapToDouble(Anomaly::getScore).max().orElse(0.0);
            info.setMinScore(minScore);
            info.setMaxScore(maxScore);
            double[] centerPoints = centroid.getCenter().getPoint();
            AtomicInteger index = new AtomicInteger();
            List centroidPoints = Doubles.asList((double[])centerPoints).stream().map(d -> new ScoredPoint((long)index.incrementAndGet(), d)).collect(Collectors.toList());
            info.setCentroid(centroidPoints);
            HashMap examples = Maps.newHashMap();
            int j = 0;
            int jStep = centroid.getPoints().size() / 20;
            for (ClusterableSegment segment : centroid.getPoints()) {
                if (jStep == 0 || j % jStep == 0) {
                    index.set(0);
                    List coordinates = Doubles.asList((double[])segment.getPoint()).stream().map(d -> new ScoredPoint((long)index.incrementAndGet(), d)).collect(Collectors.toList());
                    examples.put(TimeStampUUIDGenerator.generateId(), coordinates);
                }
                ++j;
            }
            info.setClusterExamples((Map)examples);
            double[] data = clusterAnomalies.stream().mapToDouble(Anomaly::getScore).toArray();
            EmpiricalDistribution distribution = new EmpiricalDistribution(20);
            distribution.load(data);
            ArrayList histogram = Lists.newArrayList();
            for (SummaryStatistics binStat : distribution.getBinStats()) {
                if (Double.isNaN(binStat.getMin())) continue;
                histogram.add(new ScoredPoint((long)binStat.getMin(), Double.valueOf(binStat.getN())));
            }
            info.setHistogram((List)histogram);
            result.add(info);
        }
        return result;
    }
}

