/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.ml.anomaly;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.ml.distance.DtwDistance;
import org.thingsboard.trendz.ml.domain.Anomaly;
import org.thingsboard.trendz.ml.domain.ClusterInfo;
import org.thingsboard.trendz.ml.domain.ScoredPoint;

@Component
public class AnomalyScoreTuner {
    private static final Logger log = LoggerFactory.getLogger(AnomalyScoreTuner.class);
    private static final long anomalyRange = TimeUnit.HOURS.toMillis(24L);

    public void tuneScores(List<Anomaly> anomalies, List<ClusterInfo> clusters) {
        DtwDistance measure = new DtwDistance();
        Map pointsMap = this.groupByItems(anomalies);
        List filtered = anomalies.stream().filter(a -> a.getScore() > 0.1).collect(Collectors.toList());
        for (Anomaly anomaly : filtered) {
            this.slidingWindowTune(anomaly, (List)pointsMap.get(anomaly.getItemId()), clusters, (DistanceMeasure)measure);
        }
    }

    private void slidingWindowTune(Anomaly anomaly, List<ScoredPoint> allPoints, List<ClusterInfo> clusters, DistanceMeasure measure) {
        int windowSize = clusters.get(0).getCentroid().size();
        LinkedList<ScoredPoint> window = new LinkedList<ScoredPoint>();
        Set rangePoints = allPoints.stream().filter(p -> p.getT() > anomaly.getStartTs() - anomalyRange && p.getT() < anomaly.getEndTs() + anomalyRange).collect(Collectors.toSet());
        Ints.asList((int[])new int[]{1, 3, 7, 14}).forEach(i -> rangePoints.addAll(allPoints.stream().filter(p -> p.getT() > anomaly.getStartTs() - anomalyRange * (long)i.intValue() - anomalyRange / 2L && p.getT() < anomaly.getStartTs() - anomalyRange * (long)(i - 1) + anomalyRange / 2L).collect(Collectors.toSet())));
        ScoredPoint currPoint = null;
        List collect = rangePoints.stream().sorted(Comparator.comparingLong(p -> p.getT())).collect(Collectors.toList());
        ScoredPoint ff = (ScoredPoint)collect.get(0);
        ScoredPoint ll = (ScoredPoint)collect.get(collect.size() - 1);
        int windowComparisons = 0;
        for (ScoredPoint point : collect) {
            if (window.size() < windowSize) {
                window.push(point);
                currPoint = point;
                continue;
            }
            ++windowComparisons;
            double score = this.computeScore(clusters, window, measure);
            currPoint.setS(Double.valueOf(score));
            Ints.asList((int[])new int[]{1, 3, 7, 14}).forEach(i -> {
                long stepRange = anomaly.getStartTs() - anomalyRange * (long)i.intValue();
                long leftBound = stepRange - anomalyRange / 24L - 1L;
                long rightBound = stepRange + anomalyRange / 24L + 1L;
                long windowStart = ((ScoredPoint)window.getFirst()).getT();
                if (windowStart < leftBound || windowStart <= rightBound) {
                    // empty if block
                }
            });
            window.pollFirst();
            window.push(point);
            currPoint = point;
        }
        if (anomaly == null) {
            System.out.println(windowComparisons);
        }
    }

    private int computeScore(List<ClusterInfo> clusters, List<ScoredPoint> window, DistanceMeasure measure) {
        double minScore = Double.MAX_VALUE;
        for (ClusterInfo cluster : clusters) {
            double[] windowCoordinates;
            double[] centroid = Doubles.toArray((Collection)cluster.getCentroid().stream().map(ScoredPoint::getS).collect(Collectors.toList()));
            double score = measure.compute(centroid, windowCoordinates = Doubles.toArray((Collection)window.stream().map(ScoredPoint::getS).collect(Collectors.toList())));
            if (!(minScore > score)) continue;
            minScore = score;
        }
        return (int)(minScore * 1000.0);
    }

    private Map<UUID, List<ScoredPoint>> groupByItems(List<Anomaly> anomalies) {
        Set itemIds = anomalies.stream().map(a -> a.getItemId()).collect(Collectors.toSet());
        HashMap<UUID, List<ScoredPoint>> pointsMap = new HashMap<UUID, List<ScoredPoint>>();
        for (UUID uUID : itemIds) {
        }
        return pointsMap;
    }
}

