/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.ml.anomaly;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.ml.domain.Anomaly;
import org.thingsboard.trendz.ml.domain.MlProperties;
import org.thingsboard.trendz.ml.domain.ScoredPoint;

@Component
public class AnomalyJoiner {
    private static final Logger log = LoggerFactory.getLogger(AnomalyJoiner.class);

    public List<Anomaly> joinAnomalies(List<Anomaly> anomalies, MlProperties.AnomalyExtractProperties anomalyExtractProperties) {
        anomalies.sort(Comparator.comparingDouble(Anomaly::getStartTs));
        List<Object> joinedAnomalies = Lists.newArrayList();
        double joinThreshold = 0.1;
        long joinMaxGap = TimeUnit.DAYS.toMillis(3L);
        for (UUID itemId : anomalies.stream().map(Anomaly::getItemId).collect(Collectors.toSet())) {
            ArrayList forJoin = Lists.newArrayList();
            Anomaly prev = null;
            boolean isLowScore = false;
            List itemAnomalies = anomalies.stream().filter(a -> a.getItemId().equals(itemId)).collect(Collectors.toList());
            itemAnomalies.sort(Comparator.comparingDouble(Anomaly::getStartTs));
            for (Anomaly anomaly : itemAnomalies) {
                if (prev == null) {
                    isLowScore = anomaly.getScore() < joinThreshold;
                } else if (anomaly.getScore() < joinThreshold && isLowScore || anomaly.getScore() >= joinThreshold && !isLowScore) {
                    boolean overlaps = false;
                    if (prev.getEndTs() >= anomaly.getStartTs() && prev.getEndTs() <= anomaly.getEndTs() || anomaly.getStartTs() - prev.getEndTs() < joinMaxGap) {
                        overlaps = true;
                    }
                    if (prev.getClusterId() != anomaly.getClusterId() && !anomalyExtractProperties.isJoinClusters() || !overlaps) {
                        joinedAnomalies.add(this.join((List)forJoin));
                        forJoin.clear();
                        isLowScore = anomaly.getScore() < joinThreshold;
                    }
                } else {
                    joinedAnomalies.add(this.join((List)forJoin));
                    forJoin.clear();
                    isLowScore = anomaly.getScore() < joinThreshold;
                }
                prev = anomaly;
                forJoin.add(anomaly);
            }
            if (forJoin.isEmpty()) continue;
            joinedAnomalies.add(this.join((List)forJoin));
            forJoin.clear();
        }
        joinedAnomalies = joinedAnomalies.stream().filter(a -> a.getScore() > 0.001).filter(a -> a.getEndTs() - a.getStartTs() > anomalyExtractProperties.getMinAnomalyDurationMs()).collect(Collectors.toList());
        log.info("Anomalies after join {}. Joined {}", (Object)joinedAnomalies.size(), (Object)(anomalies.size() - joinedAnomalies.size()));
        return joinedAnomalies;
    }

    private Anomaly join(List<Anomaly> anomalies) {
        long startTs = anomalies.stream().flatMap(a -> a.getData().stream()).mapToLong(ScoredPoint::getT).min().getAsLong();
        long endTs = anomalies.stream().flatMap(a -> a.getData().stream()).mapToLong(ScoredPoint::getT).max().getAsLong();
        long clusterId = anomalies.get(0).getClusterId();
        String itemName = anomalies.get(0).getItemName();
        UUID itemId = anomalies.get(0).getItemId();
        HashMap collect = new HashMap();
        anomalies.stream().flatMap(a -> a.getData().stream()).forEach(p -> {
            List records = collect.computeIfAbsent(p.getT(), i -> new ArrayList());
            records.add(p);
        });
        for (Map.Entry entry : collect.entrySet()) {
            double minScore = ((List)entry.getValue()).stream().mapToDouble(s -> s.getS()).min().getAsDouble();
            ((List)entry.getValue()).stream().forEach(s -> s.setS(Double.valueOf(minScore)));
        }
        ArrayList segRecords = Lists.newArrayList((Iterable)collect.values().stream().flatMap(v -> v.stream()).collect(Collectors.toSet()));
        segRecords = Lists.newArrayList((Iterable)Sets.newHashSet((Iterable)segRecords));
        segRecords.sort(Comparator.comparingLong(ScoredPoint::getT));
        double maxScore = segRecords.stream().mapToDouble(r -> r.getS()).max().getAsDouble();
        Anomaly joined = new Anomaly();
        joined.setItemId(itemId);
        joined.setItemName(itemName);
        joined.setStartTs(startTs);
        joined.setEndTs(endTs);
        joined.setClusterId(clusterId);
        joined.setScore(maxScore);
        joined.setData((List)segRecords);
        joined.setScoreIndex(this.computeScoreIndex((List)segRecords));
        return joined;
    }

    private int computeScoreIndex(List<ScoredPoint> points) {
        double sumIndex = 0.0;
        for (int i = 1; i < points.size(); ++i) {
            ScoredPoint curr = points.get(i);
            ScoredPoint prev = points.get(i - 1);
            sumIndex += (prev.getS() + curr.getS()) * (double)(curr.getT() - prev.getT()) / (double)TimeUnit.HOURS.toMillis(1L) / 2.0;
        }
        return (int)sumIndex;
    }
}

