/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.ml.anomaly;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.ml.anomaly.AnomalyJoiner;
import org.thingsboard.trendz.ml.domain.Anomaly;
import org.thingsboard.trendz.ml.domain.ClusterInfo;
import org.thingsboard.trendz.ml.domain.ClusterModel;
import org.thingsboard.trendz.ml.domain.ClusterableSegment;
import org.thingsboard.trendz.ml.domain.ComplexTsPoint;
import org.thingsboard.trendz.ml.domain.MlProperties;
import org.thingsboard.trendz.ml.domain.ScoredPoint;
import org.thingsboard.trendz.ml.domain.Segment;
import org.thingsboard.trendz.ml.util.MlUtil;

@Component
public class AnomalyExtractor {
    private static final Logger log = LoggerFactory.getLogger(AnomalyExtractor.class);
    @Autowired
    private AnomalyJoiner anomalyJoiner;

    public List<Anomaly> buildAnomalies(ClusterModel model, List<Segment> segments) {
        List centroids = model.getClusters().stream().map(ClusterInfo::getCentroid).collect(Collectors.toList());
        return this.extract(centroids, segments, model.getProperties());
    }

    public List<Anomaly> buildPrecomputedAnomalies(List<CentroidCluster<ClusterableSegment>> centroids, MlProperties properties) {
        List clusterCentroids = centroids.stream().map(cl -> cl.getCenter()).map(cl -> Doubles.asList((double[])cl.getPoint()).stream().map(d -> new ScoredPoint(0L, d)).collect(Collectors.toList())).collect(Collectors.toList());
        List segments = centroids.stream().flatMap(c -> c.getPoints().stream()).map(cs -> cs.getSegment()).collect(Collectors.toList());
        return this.extract(clusterCentroids, segments, properties);
    }

    private List<Anomaly> extract(List<List<ScoredPoint>> centroids, List<Segment> segments, MlProperties properties) {
        segments.sort(Comparator.comparingLong(Segment::getMinTs));
        DistanceMeasure measure = this.getMeasure(properties);
        ArrayList anomalies = Lists.newArrayList();
        for (Segment segment : segments) {
            long nearestClusterId = Long.MIN_VALUE;
            double minDistance = Double.MAX_VALUE;
            long clusterId = 0L;
            for (List<ScoredPoint> centroid : centroids) {
                ++clusterId;
                double[] centerPoints = Doubles.toArray((Collection)centroid.stream().map(ScoredPoint::getS).collect(Collectors.toList()));
                double distance = measure.compute(centerPoints, segment.getFeatures());
                if (!(minDistance > distance) && nearestClusterId != Long.MIN_VALUE) continue;
                minDistance = distance;
                nearestClusterId = clusterId;
            }
            Anomaly anomaly = this.createAnomaly(segment, nearestClusterId, minDistance);
            anomalies.add(anomaly);
        }
        this.computeScoreThreshold((List)anomalies, properties.getAnomalyExtractProperties());
        log.info("{} anomalies found", (Object)anomalies.size());
        return this.anomalyJoiner.joinAnomalies((List)anomalies, properties.getAnomalyExtractProperties());
    }

    private Anomaly createAnomaly(Segment segment, long clusterId, double distance) {
        ComplexTsPoint lastPoint = (ComplexTsPoint)Iterables.getLast((Iterable)segment.getRecords());
        int score = this.distanceToScore(distance);
        Anomaly anomaly = new Anomaly();
        anomaly.setItemId(segment.getItemId());
        anomaly.setClusterId(clusterId);
        anomaly.setStartTs(lastPoint.getTs());
        anomaly.setEndTs(lastPoint.getTs());
        anomaly.setScore((double)score);
        anomaly.setData((List)Lists.newArrayList((Object[])new ScoredPoint[]{new ScoredPoint(lastPoint.getTs(), Double.valueOf(score))}));
        return anomaly;
    }

    private void computeScoreThreshold(List<Anomaly> anomalies, MlProperties.AnomalyExtractProperties anomalyExtractProperties) {
        double percentile = anomalyExtractProperties.getPercentile();
        if (percentile < 1.0 || percentile > 100.0) {
            percentile = 10.0;
        }
        double[] scores = Doubles.toArray((Collection)anomalies.stream().map(Anomaly::getScore).collect(Collectors.toList()));
        double threshold = new Percentile().evaluate(scores, 100.0 - percentile);
        anomalies.forEach(a -> {
            if (a.getScore() < threshold) {
                a.setScore(0.0);
                a.getData().forEach(sp -> sp.setS(Double.valueOf(0.0)));
            }
        });
    }

    private DistanceMeasure getMeasure(MlProperties properties) {
        return MlUtil.getMeasure((MlProperties.DistanceFunctionType)properties.getAnomalyScoreDistFunc());
    }

    private int distanceToScore(double distance) {
        return (int)(distance * 1000.0);
    }
}

