/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.ml;

import java.util.List;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.dao.ml.ModelDao;
import org.thingsboard.trendz.dao.sql.TimeStampUUIDGenerator;
import org.thingsboard.trendz.ml.ClusteringService;
import org.thingsboard.trendz.ml.domain.ClusterModel;
import org.thingsboard.trendz.ml.domain.DataVector;
import org.thingsboard.trendz.ml.domain.DatasetConfig;
import org.thingsboard.trendz.ml.domain.Model;
import org.thingsboard.trendz.ml.domain.ModelProperties;
import org.thingsboard.trendz.ml.domain.ModelStatus;
import org.thingsboard.trendz.ml.domain.ModelType;
import org.thingsboard.trendz.ml.fetcher.CompositeDatasetFetcher;
import org.thingsboard.trendz.task.ProgressStep;
import org.thingsboard.trendz.task.Task;
import org.thingsboard.trendz.task.TaskService;
import org.thingsboard.trendz.task.TaskType;

@Component
public class ModelService {
    private static final Logger log = LoggerFactory.getLogger(ModelService.class);
    @Autowired
    private ModelDao modelDao;
    @Autowired
    private ClusteringService clusteringService;
    @Autowired
    private CompositeDatasetFetcher datasetFetcher;
    @Autowired
    private TaskService taskService;

    public List<Model> getAllModels(TenantId tenantId) {
        return this.modelDao.getAll(tenantId.getId());
    }

    public Model getModelById(UUID modelId) {
        Model model = this.modelDao.findById(modelId);
        if (model == null) {
            throw new IllegalStateException("Model not found by Id " + modelId);
        }
        return model;
    }

    public boolean saveModel(Model model) {
        if (model.getId() == null) {
            model.setId(TimeStampUUIDGenerator.generateId());
            log.debug("----------- Model is new therefore new Id set = {}", (Object)model.getId());
        } else {
            log.debug("----------- Model already exists therefore persisted model will be removed, model id = {}", (Object)model.getId());
            this.modelDao.delete(model.getId(), true);
        }
        this.modelDao.save(model);
        return true;
    }

    public boolean deleteModel(UUID modelId) {
        this.modelDao.delete(modelId, false);
        return true;
    }

    public Task<Model> buildModelAsync(ModelProperties properties) {
        Model model = this.createModel(properties);
        Task modelTask = this.taskService.submitTask(TaskType.BUILD_MODEL, model.getId(), task -> this.buildModel(task, model, properties));
        modelTask.setResult((Object)model);
        return modelTask;
    }

    private Model buildModel(Task task, Model model, ModelProperties properties) {
        long startTs = System.currentTimeMillis();
        if (ModelType.CLUSTERING.equals((Object)properties.getModelType())) {
            Model readyModel = this.buildClusterModel(task, (ClusterModel)model, properties);
            log.info("Model Ready in {} ms", (Object)(System.currentTimeMillis() - startTs));
            return readyModel;
        }
        throw new IllegalStateException("model type not supported " + properties.getModelType());
    }

    private Model buildClusterModel(Task task, ClusterModel model, ModelProperties properties) {
        try {
            model.setStatus(ModelStatus.IN_PROGRESS);
            long startTs = System.currentTimeMillis();
            ProgressStep dataFetchStep = ProgressStep.builder().order(task.getProgress().getSteps().size() + 1).description("Prepare dataset").started(true).build();
            task.getProgress().getSteps().add(dataFetchStep);
            DatasetConfig datasetConfig = properties.getDatasetConfig();
            datasetConfig.setMaxPointsCount(model.getProperties().getSegmentSplitProperties().getMaxPointsCount());
            List dataset = this.datasetFetcher.fetchDataset(datasetConfig);
            dataFetchStep.setCompleted(true);
            dataFetchStep.setDurationMs(System.currentTimeMillis() - startTs);
            this.validateDataset(dataset);
            model = this.clusteringService.computeClusters(task, model, dataset);
            model.setStatus(ModelStatus.READY);
        }
        catch (Throwable th) {
            model.setStatus(ModelStatus.CANCELED);
            log.error("Cluster model build failed {}", (Object)model, (Object)th);
            throw th;
        }
        finally {
            this.saveModel((Model)model);
        }
        return model;
    }

    private void validateDataset(List<DataVector> dataset) {
        if (CollectionUtils.isEmpty(dataset)) {
            throw new IllegalStateException("No Items found for configured datasource");
        }
        long totalPoints = dataset.stream().mapToLong(dv -> dv.getPoints().values().stream().mapToLong(List::size).sum()).sum();
        if (totalPoints < 50L) {
            throw new IllegalStateException("Found " + totalPoints + " points. But minimum 50 points required");
        }
    }

    private Model createModel(ModelProperties properties) {
        if (ModelType.CLUSTERING.equals((Object)properties.getModelType())) {
            ClusterModel model = properties.getFromModelID() != null ? (ClusterModel)this.getModelById(properties.getFromModelID()) : new ClusterModel();
            model.setTenantId(properties.getDatasetConfig().getTenantId().getId());
            model.setName(properties.getName());
            model.setCreateTs(System.currentTimeMillis());
            model.setStatus(ModelStatus.QUEUED);
            model.setProperties(properties.getMlProperties());
            model.setType(ModelType.CLUSTERING);
            model.setDatasetConfig(properties.getDatasetConfig());
            this.saveModel((Model)model);
            return model;
        }
        throw new IllegalStateException("model type not supported " + properties.getModelType());
    }
}

