/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.ml;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.dao.sql.TimeStampUUIDGenerator;
import org.thingsboard.trendz.ml.ClusterTaskCache;
import org.thingsboard.trendz.ml.ClusteringService;
import org.thingsboard.trendz.ml.domain.ClusterReport;
import org.thingsboard.trendz.ml.domain.ClusterTask;
import org.thingsboard.trendz.ml.domain.DataVector;
import org.thingsboard.trendz.ml.util.FakeMlDataFetcher;

@Component
public class MLService {
    private static final Logger log = LoggerFactory.getLogger(MLService.class);
    @Autowired
    private ClusterTaskCache clusterTaskCache;
    @Autowired
    private ClusteringService clusteringService;
    @Autowired
    private FakeMlDataFetcher fakeMlDataFetcher;
    private ExecutorService taskExecutorService;

    @PostConstruct
    public void init() {
        this.taskExecutorService = Executors.newFixedThreadPool(1);
    }

    @PreDestroy
    public void destroy() {
        this.taskExecutorService.shutdownNow();
    }

    public ClusterTask runAsyncClusterTask(TenantId tenantId, String jwtToken) {
        ClusterTask clusterTask = new ClusterTask();
        clusterTask.setId(TimeStampUUIDGenerator.generateId());
        this.clusterTaskCache.addInProgressTask(clusterTask);
        log.info("Submit Cluster Task for execution {}", (Object)clusterTask.getId());
        this.taskExecutorService.submit(() -> {
            try {
                log.info("Start executing cluster task {}", (Object)clusterTask.getId());
                ClusterReport clusterReport = null;
                clusterTask.setClusterReport(clusterReport);
                this.clusterTaskCache.finishTask(clusterTask.getId());
                log.debug("Cluster task ready {}", (Object)clusterTask.getId());
            }
            catch (Exception ex) {
                log.error("Problem while executing cluster task " + clusterTask.getId(), (Throwable)ex);
                this.clusterTaskCache.cancelTask(clusterTask.getId(), ex.getMessage());
            }
        });
        return clusterTask;
    }

    private List<DataVector> fetchData() {
        return this.fakeMlDataFetcher.fetch();
    }
}

