/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.ml;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.ml.AnomalyService;
import org.thingsboard.trendz.ml.cluster.ClusterInfoBuilder;
import org.thingsboard.trendz.ml.cluster.CompositeSegmentClusterer;
import org.thingsboard.trendz.ml.domain.ClusterModel;
import org.thingsboard.trendz.ml.domain.ClusterReport;
import org.thingsboard.trendz.ml.domain.DataVector;
import org.thingsboard.trendz.ml.domain.FeatureStatistic;
import org.thingsboard.trendz.ml.domain.MlProperties;
import org.thingsboard.trendz.ml.domain.Segment;
import org.thingsboard.trendz.ml.domain.SimpleTsPoint;
import org.thingsboard.trendz.ml.features.FeatureBuilder;
import org.thingsboard.trendz.ml.segment.CompositSegmentSplitter;
import org.thingsboard.trendz.ml.segment.DataVectorTransformer;
import org.thingsboard.trendz.ml.segment.SegmentFilterer;
import org.thingsboard.trendz.task.ProgressStep;
import org.thingsboard.trendz.task.Task;

@Component
public class ClusteringService {
    private static final Logger log = LoggerFactory.getLogger(ClusteringService.class);
    @Autowired
    private CompositSegmentSplitter segmentSplitter;
    @Autowired
    private SegmentFilterer segmentFilterer;
    @Autowired
    private FeatureBuilder featureBuilder;
    @Autowired
    private CompositeSegmentClusterer segmentClusterer;
    @Autowired
    private AnomalyService anomalyService;
    @Autowired
    private ClusterInfoBuilder clusterInfoBuilder;
    @Autowired
    private DataVectorTransformer dataVectorTransformer;

    public ClusterModel computeClusters(Task task, ClusterModel model, List<DataVector> data) {
        ProgressStep segmentsBuildStep = ProgressStep.builder().order(task.getProgress().getSteps().size() + 1).description("Analyze segments").started(true).build();
        task.getProgress().getSteps().add(segmentsBuildStep);
        long startTs = System.currentTimeMillis();
        Map fieldsStatistic = this.buildStatistic(data);
        model.getProperties().getFeatureProperties().setFieldStatistic(fieldsStatistic);
        List segments = this.buildSegments(data, model.getProperties());
        if (segments.size() < model.getProperties().getClusteringProperties().getClustersCount() && segments.size() > 0) {
            model.getProperties().getClusteringProperties().setClustersCount(segments.size());
        }
        segmentsBuildStep.setExpectedOperations((long)segments.size());
        segmentsBuildStep.setFinishedOperations((long)segments.size());
        segmentsBuildStep.setCompleted(true);
        segmentsBuildStep.setDurationMs(System.currentTimeMillis() - startTs);
        ProgressStep modelBuildStep = ProgressStep.builder().order(task.getProgress().getSteps().size() + 1).description("Build Model").started(true).build();
        task.getProgress().getSteps().add(modelBuildStep);
        startTs = System.currentTimeMillis();
        List clusters = this.segmentClusterer.cluster(segments, model.getProperties().getClusteringProperties());
        modelBuildStep.setCompleted(true);
        modelBuildStep.setDurationMs(System.currentTimeMillis() - startTs);
        ProgressStep extractAnomaliesStep = ProgressStep.builder().order(task.getProgress().getSteps().size() + 1).description("Extract anomalies").started(true).build();
        task.getProgress().getSteps().add(extractAnomaliesStep);
        startTs = System.currentTimeMillis();
        List anomalies = this.anomalyService.discoverPrecomputedAnomalies(clusters, model, data, task.getId());
        List clusterInfos = this.clusterInfoBuilder.build(clusters, anomalies);
        extractAnomaliesStep.setCompleted(true);
        extractAnomaliesStep.setDurationMs(System.currentTimeMillis() - startTs);
        ClusterReport clusterReport = new ClusterReport();
        clusterReport.setAnomalies(anomalies);
        clusterReport.setClusters(clusterInfos);
        model.setClusters(clusterInfos);
        return model;
    }

    public List<Segment> buildSegments(List<DataVector> data, MlProperties mlProperties) {
        List result = Lists.newArrayList();
        for (DataVector itemData : data) {
            List complexTsPoints = this.dataVectorTransformer.toComplexPoints(itemData.getPoints());
            List segments = this.segmentSplitter.split(complexTsPoints, mlProperties.getSegmentSplitProperties());
            segments.forEach(s -> s.setItemId(itemData.getItemId()));
            result.addAll(segments);
        }
        log.info("Total segments found {} for {} items", (Object)result.size(), (Object)data.size());
        result = this.segmentFilterer.filter(result, mlProperties.getSegmentFilterProperties());
        result = this.featureBuilder.buildFeatures(result, mlProperties.getFeatureProperties());
        return result;
    }

    private Map<UUID, FeatureStatistic> buildStatistic(List<DataVector> data) {
        HashMap<UUID, FeatureStatistic> fieldStats = new HashMap<UUID, FeatureStatistic>();
        Set fieldIds = data.stream().flatMap(s -> s.getPoints().keySet().stream()).collect(Collectors.toSet());
        for (UUID fieldId : fieldIds) {
            double min = data.stream().flatMap(dv -> ((List)dv.getPoints().get(fieldId)).stream()).mapToDouble(SimpleTsPoint::getValue).min().orElse(0.0);
            double max = data.stream().flatMap(dv -> ((List)dv.getPoints().get(fieldId)).stream()).mapToDouble(SimpleTsPoint::getValue).max().orElse(0.0);
            double avg = data.stream().flatMap(dv -> ((List)dv.getPoints().get(fieldId)).stream()).mapToDouble(SimpleTsPoint::getValue).average().orElse(0.0);
            FeatureStatistic fs = new FeatureStatistic();
            fs.setMin(min);
            fs.setMax(max);
            fs.setAvg(avg);
            fieldStats.put(fieldId, fs);
        }
        return fieldStats;
    }
}

