/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.ml;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.ml.domain.ClusterReport;
import org.thingsboard.trendz.ml.domain.ClusterTask;

@Component
public class ClusterTaskCache {
    private static final Logger log = LoggerFactory.getLogger(ClusterTaskCache.class);
    private Map<UUID, ClusterTask> taskCache = new ConcurrentHashMap();
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();

    @PostConstruct
    public void init() {
        this.executorService.scheduleAtFixedRate(() -> {
            HashSet forRemove = Sets.newHashSet();
            for (Map.Entry entry : this.taskCache.entrySet()) {
                if (((ClusterTask)entry.getValue()).isFinished()) {
                    if (System.currentTimeMillis() - ((ClusterTask)entry.getValue()).getFinishedAt() <= TimeUnit.SECONDS.toMillis(60L)) continue;
                    forRemove.add(entry.getKey());
                    continue;
                }
                if (System.currentTimeMillis() - ((ClusterTask)entry.getValue()).getCreatedAt() <= TimeUnit.MINUTES.toMillis(60L)) continue;
                ((ClusterTask)entry.getValue()).setCanceled(true);
                forRemove.add(entry.getKey());
                log.warn("Long running View Task detected id [{}] created [{}]", entry.getKey(), (Object)((ClusterTask)entry.getValue()).getCreatedAt());
            }
            forRemove.forEach(id -> {
                ClusterTask cfr_ignored_0 = (ClusterTask)this.taskCache.remove(id);
            });
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    @PreDestroy
    public void close() {
        this.executorService.shutdownNow();
    }

    public Optional<ClusterTask> getTask(UUID id) {
        ClusterTask clusterTask = (ClusterTask)this.taskCache.get(id);
        if (clusterTask != null) {
            return Optional.of(clusterTask);
        }
        return Optional.empty();
    }

    public void addInProgressTask(ClusterTask viewTask) {
        viewTask.setCreatedAt(System.currentTimeMillis());
        this.taskCache.put(viewTask.getId(), viewTask);
    }

    public void finishTask(UUID taskId) {
        Optional task = this.getTask(taskId);
        if (task.isPresent()) {
            ((ClusterTask)task.get()).setFinishedAt(System.currentTimeMillis());
            ((ClusterTask)task.get()).setFinished(true);
            long duration = TimeUnit.MILLISECONDS.toMillis(((ClusterTask)task.get()).getFinishedAt() - ((ClusterTask)task.get()).getCreatedAt());
            if (((ClusterTask)task.get()).getClusterReport() != null) {
                ClusterReport report = ((ClusterTask)task.get()).getClusterReport();
                log.info("Clustering data ready in {} millis. Clusters {} Anomalies {}", new Object[]{duration, report.getClusters().size(), report.getAnomalies().size()});
            }
            log.warn("Clustering data ready in {} millis. Empty", (Object)duration);
        } else {
            log.warn("Task {} finished, but was canceled previously", (Object)taskId);
        }
    }

    public void cancelTask(UUID taskId, String reason) {
        Optional task = this.getTask(taskId);
        if (task.isPresent() && !((ClusterTask)task.get()).isFinished()) {
            ((ClusterTask)task.get()).setCanceled(true);
            ((ClusterTask)task.get()).setCancelReason(reason);
            if (((ClusterTask)task.get()).getDisposableTask() != null) {
                ((ClusterTask)task.get()).getDisposableTask().dispose();
            }
        } else {
            log.warn("Task {} was canceled/finished previously", (Object)taskId);
        }
    }
}

