/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.ml;

import com.clearspring.analytics.util.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.dao.ml.AnomalyDao;
import org.thingsboard.trendz.ml.ClusteringService;
import org.thingsboard.trendz.ml.ModelService;
import org.thingsboard.trendz.ml.anomaly.AnomalyExtractor;
import org.thingsboard.trendz.ml.anomaly.AnomalyFilter;
import org.thingsboard.trendz.ml.domain.Anomaly;
import org.thingsboard.trendz.ml.domain.ClusterModel;
import org.thingsboard.trendz.ml.domain.ClusterableSegment;
import org.thingsboard.trendz.ml.domain.DataVector;
import org.thingsboard.trendz.ml.domain.DatasetConfig;
import org.thingsboard.trendz.ml.domain.Model;
import org.thingsboard.trendz.ml.domain.ModelType;
import org.thingsboard.trendz.ml.domain.SimpleTsPoint;
import org.thingsboard.trendz.ml.fetcher.CompositeDatasetFetcher;
import org.thingsboard.trendz.ml.fetcher.DatasetIterator;
import org.thingsboard.trendz.task.ProgressStep;
import org.thingsboard.trendz.task.Task;
import org.thingsboard.trendz.task.TaskService;
import org.thingsboard.trendz.task.TaskType;

@Component
public class AnomalyService {
    private static final Logger log = LoggerFactory.getLogger(AnomalyService.class);
    @Autowired
    private ModelService modelService;
    @Autowired
    private ClusteringService clusteringService;
    @Autowired
    private AnomalyExtractor anomalyExtractor;
    @Autowired
    private CompositeDatasetFetcher datasetFetcher;
    @Autowired
    private TaskService taskService;
    @Autowired
    private AnomalyDao anomalyDao;

    public boolean removeByTaskId(UUID taskId) {
        this.anomalyDao.removeByTaskId(taskId);
        return true;
    }

    public boolean removeByModelId(UUID modelId) {
        this.anomalyDao.removeByModelId(modelId);
        return true;
    }

    public List<Anomaly> getAnomalies(AnomalyFilter filter) {
        return this.anomalyDao.find(filter);
    }

    public List<Anomaly> discoverPrecomputedAnomalies(List<CentroidCluster<ClusterableSegment>> clusters, ClusterModel model, List<DataVector> data, UUID taskId) {
        List anomalies = this.anomalyExtractor.buildPrecomputedAnomalies(clusters, model.getProperties());
        anomalies.forEach(a -> {
            a.setModelId(model.getId());
            a.setTaskId(taskId);
        });
        this.fillItemNames(anomalies, data);
        this.anomalyDao.save(anomalies);
        return anomalies;
    }

    public Task<List<Anomaly>> discoverAnomaliesAsync(UUID modelId, DatasetConfig datasetConfig) {
        return this.taskService.submitTask(TaskType.FIND_ANOMALIES, modelId, task -> this.discoverAnomalies(task, modelId, datasetConfig));
    }

    public List<Anomaly> discoverAnomalies(Task task, UUID modelId, DatasetConfig datasetConfig) {
        Model model = this.modelService.getModelById(modelId);
        datasetConfig.setMaxPointsCount(model.getProperties().getSegmentSplitProperties().getMaxPointsCount());
        List allAnomalies = Lists.newArrayList();
        long startTs = System.currentTimeMillis();
        ProgressStep resolveItemsStep = ProgressStep.builder().order(task.getProgress().getSteps().size() + 1).description("Resolve Items").started(true).build();
        task.getProgress().getSteps().add(resolveItemsStep);
        DatasetIterator datasetIterator = this.datasetFetcher.getDatasetIterator(datasetConfig);
        resolveItemsStep.setDurationMs(System.currentTimeMillis() - startTs);
        resolveItemsStep.setCompleted(true);
        resolveItemsStep.setExpectedOperations((long)datasetIterator.getUnproccessedSize());
        resolveItemsStep.setFinishedOperations((long)datasetIterator.getUnproccessedSize());
        startTs = System.currentTimeMillis();
        ProgressStep processItemsStep = ProgressStep.builder().order(task.getProgress().getSteps().size() + 1).description("Process Items").expectedOperations((long)datasetIterator.getUnproccessedSize()).started(true).build();
        task.getProgress().getSteps().add(processItemsStep);
        while (datasetIterator.hasNext()) {
            try {
                List dataset = datasetIterator.next();
                List anomalies = this.detect(model, dataset);
                anomalies.forEach(a -> {
                    a.setModelId(modelId);
                    a.setTaskId(task.getId());
                });
                this.fillItemNames(anomalies, dataset);
                this.anomalyDao.save(anomalies);
                allAnomalies.addAll(anomalies);
            }
            catch (Exception ex) {
                log.error("Could not detect anomalies for item", (Throwable)ex);
            }
            processItemsStep.setFinishedOperations((long)datasetIterator.getProccessedSize());
        }
        processItemsStep.setDurationMs(System.currentTimeMillis() - startTs);
        processItemsStep.setCompleted(true);
        return allAnomalies;
    }

    private List<Anomaly> detect(Model model, List<DataVector> data) {
        if (ModelType.CLUSTERING.equals((Object)model.getType())) {
            ClusterModel clusterModel = (ClusterModel)model;
            List segments = this.clusteringService.buildSegments(data, model.getProperties());
            return this.anomalyExtractor.buildAnomalies(clusterModel, segments);
        }
        throw new IllegalStateException("model type not supported " + model.getType());
    }

    private void fillItemNames(List<Anomaly> anomalies, List<DataVector> data) {
        Map<UUID, String> idToName = data.stream().collect(Collectors.toMap(dv -> dv.getItemId(), dv -> dv.getItemName()));
        anomalies.forEach(a -> a.setItemName((String)idToName.get(a.getItemId())));
    }

    public Map<UUID, List<SimpleTsPoint>> getItemFieldValues(DatasetConfig datasetConfig, UUID viewFieldId, String itemName, long startTs, long endTs) {
        datasetConfig.setStartTs(startTs);
        datasetConfig.setEndTs(endTs);
        List dataset = this.datasetFetcher.fetchItemFieldFromDataset(datasetConfig, viewFieldId, itemName);
        if (dataset.isEmpty()) {
            return Collections.emptyMap();
        }
        if (dataset.size() > 1) {
            throw new IllegalStateException("Multiple vectors loaded for field");
        }
        DataVector dataVector = (DataVector)dataset.get(0);
        if (dataVector.getItemName().equals(itemName)) {
            return dataVector.getPoints();
        }
        throw new IllegalStateException("Not found data vector for item " + itemName);
    }
}

