/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.runtime;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.service.cache.TimeRange;

public class Item {
    private UUID id;
    private UUID parentId;
    private UUID ownerId;
    private String name;
    private String label;
    private Map<String, String> attributes;
    private Map<String, Map<TimeRange, List<FieldValue>>> telemetryRequestCache = new ConcurrentHashMap();

    public Item(UUID id, UUID parentId, UUID ownerId, String name, String label) {
        this.id = id;
        this.parentId = parentId;
        this.ownerId = ownerId;
        this.name = name;
        this.label = label;
    }

    public void saveItemTelemetry(long start, long end, String telemetryKey, List<FieldValue> data) {
        TimeRange queriedRange = new TimeRange(start, end);
        this.telemetryRequestCache.computeIfAbsent(telemetryKey, i -> new ConcurrentHashMap()).put(queriedRange, new CopyOnWriteArrayList<FieldValue>(data));
    }

    public List<FieldValue> getSavedItemTelemetry(long start, long end, String telemetryKey) {
        TimeRange queriedRange = new TimeRange(start, end);
        return (List)this.telemetryRequestCache.computeIfAbsent(telemetryKey, i -> new ConcurrentHashMap()).get(queriedRange);
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getParentId() {
        return this.parentId;
    }

    public UUID getOwnerId() {
        return this.ownerId;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Map<String, Map<TimeRange, List<FieldValue>>> getTelemetryRequestCache() {
        return this.telemetryRequestCache;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setParentId(UUID parentId) {
        this.parentId = parentId;
    }

    public void setOwnerId(UUID ownerId) {
        this.ownerId = ownerId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public void setTelemetryRequestCache(Map<String, Map<TimeRange, List<FieldValue>>> telemetryRequestCache) {
        this.telemetryRequestCache = telemetryRequestCache;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Item)) {
            return false;
        }
        Item other = (Item)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$parentId = this.getParentId();
        UUID other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !((Object)this$parentId).equals(other$parentId)) {
            return false;
        }
        UUID this$ownerId = this.getOwnerId();
        UUID other$ownerId = other.getOwnerId();
        if (this$ownerId == null ? other$ownerId != null : !((Object)this$ownerId).equals(other$ownerId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        Map this$attributes = this.getAttributes();
        Map other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Item;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : ((Object)$parentId).hashCode());
        UUID $ownerId = this.getOwnerId();
        result = result * 59 + ($ownerId == null ? 43 : ((Object)$ownerId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        Map $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    public String toString() {
        return "Item(id=" + this.getId() + ", parentId=" + this.getParentId() + ", ownerId=" + this.getOwnerId() + ", name=" + this.getName() + ", label=" + this.getLabel() + ", attributes=" + this.getAttributes() + ")";
    }
}

