/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.runtime;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.state.State;

public class FieldValue {
    private Set<Item> items;
    private FieldType fieldType;
    private Object innerValue;
    private long ts;
    private String keyName;
    private boolean isState;
    private State innerState;

    public FieldValue(Item item, FieldType fieldType, Object innerValue) {
        this(item, fieldType, innerValue, 0L);
    }

    public FieldValue(Set<Item> items, FieldType fieldType, Object innerValue) {
        this(items, fieldType, innerValue, 0L);
    }

    public FieldValue(Item item, FieldType fieldType, Object innerValue, long ts) {
        this.items = Collections.singleton(item);
        this.fieldType = fieldType;
        this.innerValue = innerValue;
        this.ts = ts;
    }

    public FieldValue(Set<Item> items, FieldType fieldType, Object innerValue, long ts) {
        this.items = items;
        this.fieldType = fieldType;
        this.innerValue = innerValue;
        this.ts = ts;
    }

    public Optional<Double> getNumeric() {
        if (this.fieldType.equals((Object)FieldType.NUMERIC) && this.innerValue != null) {
            return Optional.of(((Number)this.innerValue).doubleValue());
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldValue that = (FieldValue)o;
        return new EqualsBuilder().append((Object)this.fieldType, (Object)that.fieldType).append(this.innerValue, that.innerValue).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.fieldType).append(this.innerValue).toHashCode();
    }

    public Set<Item> getItems() {
        return this.items;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public Object getInnerValue() {
        return this.innerValue;
    }

    public long getTs() {
        return this.ts;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public boolean isState() {
        return this.isState;
    }

    public State getInnerState() {
        return this.innerState;
    }

    public void setItems(Set<Item> items) {
        this.items = items;
    }

    public void setFieldType(FieldType fieldType) {
        this.fieldType = fieldType;
    }

    public void setInnerValue(Object innerValue) {
        this.innerValue = innerValue;
    }

    public void setTs(long ts) {
        this.ts = ts;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public void setState(boolean isState) {
        this.isState = isState;
    }

    public void setInnerState(State innerState) {
        this.innerState = innerState;
    }

    public String toString() {
        return "FieldValue(items=" + this.getItems() + ", fieldType=" + this.getFieldType() + ", innerValue=" + this.getInnerValue() + ", ts=" + this.getTs() + ", keyName=" + this.getKeyName() + ", isState=" + this.isState() + ", innerState=" + this.getInnerState() + ")";
    }
}

