/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.domain.runtime.DataCell;

public class DataRow {
    private EntityId entityId;
    private String entityName;
    private List<DataCell> cells = new ArrayList();

    public DataRow copy() {
        DataRow copy = new DataRow();
        copy.setEntityId(this.entityId);
        copy.setEntityName(this.entityName);
        for (DataCell cell : this.cells) {
            copy.getCells().add(new DataCell(cell.getViewFieldId(), cell.getData()));
        }
        return copy;
    }

    public DataCell findCellByFieldId(UUID id) {
        return this.cells.stream().filter(c -> c.getViewFieldId().equals(id)).findFirst().get();
    }

    public EntityId getEntityId() {
        return this.entityId;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public List<DataCell> getCells() {
        return this.cells;
    }

    public void setEntityId(EntityId entityId) {
        this.entityId = entityId;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public void setCells(List<DataCell> cells) {
        this.cells = cells;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataRow)) {
            return false;
        }
        DataRow other = (DataRow)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        EntityId this$entityId = this.getEntityId();
        EntityId other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        String this$entityName = this.getEntityName();
        String other$entityName = other.getEntityName();
        if (this$entityName == null ? other$entityName != null : !this$entityName.equals(other$entityName)) {
            return false;
        }
        List this$cells = this.getCells();
        List other$cells = other.getCells();
        return !(this$cells == null ? other$cells != null : !((Object)this$cells).equals(other$cells));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataRow;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntityId $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        String $entityName = this.getEntityName();
        result = result * 59 + ($entityName == null ? 43 : $entityName.hashCode());
        List $cells = this.getCells();
        result = result * 59 + ($cells == null ? 43 : ((Object)$cells).hashCode());
        return result;
    }

    public String toString() {
        return "DataRow(entityId=" + this.getEntityId() + ", entityName=" + this.getEntityName() + ", cells=" + this.getCells() + ")";
    }
}

