/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.definition.view.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.thingsboard.trendz.domain.definition.view.config.CacheSettings;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfigDefinition;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.definition.view.config.ViewType;

public class ViewConfig {
    private UUID id;
    private String name;
    private ViewType viewType;
    private ViewConfigDefinition configDefinition;
    private UUID rootEntityId;
    private UUID rowClickEntityId;
    private CacheSettings cacheSettings;
    private long createdAt;
    private long updatedAt;
    private List<ViewField> xAxis;
    private List<ViewField> yAxis;
    private List<ViewField> series;
    private List<ViewField> hiddenFields;
    private List<RuntimeFilterField> runtimeFilters;
    private JsonNode settings;
    private DatePickerConfig datePickerConfig;
    private String tzName;

    public List<ViewField> getxAxis() {
        return this.xAxis;
    }

    public void setxAxis(List<ViewField> xAxis) {
        this.xAxis = xAxis;
    }

    public List<ViewField> getyAxis() {
        return this.yAxis;
    }

    public void setyAxis(List<ViewField> yAxis) {
        this.yAxis = yAxis;
    }

    @JsonIgnore
    public Set<UUID> getAdditionalEntityIds() {
        HashSet ids = Sets.newHashSet();
        JsonNode settings = this.getSettings();
        JsonNode missedGraphEntities = settings.get("missedGraphEntities");
        if (missedGraphEntities != null && !missedGraphEntities.isMissingNode()) {
            for (JsonNode node : missedGraphEntities) {
                UUID uuid = UUID.fromString(node.textValue());
                ids.add(uuid);
            }
        }
        return ids;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public ViewType getViewType() {
        return this.viewType;
    }

    public ViewConfigDefinition getConfigDefinition() {
        return this.configDefinition;
    }

    public UUID getRootEntityId() {
        return this.rootEntityId;
    }

    public UUID getRowClickEntityId() {
        return this.rowClickEntityId;
    }

    public CacheSettings getCacheSettings() {
        return this.cacheSettings;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public List<ViewField> getSeries() {
        return this.series;
    }

    public List<ViewField> getHiddenFields() {
        return this.hiddenFields;
    }

    public List<RuntimeFilterField> getRuntimeFilters() {
        return this.runtimeFilters;
    }

    public JsonNode getSettings() {
        return this.settings;
    }

    public DatePickerConfig getDatePickerConfig() {
        return this.datePickerConfig;
    }

    public String getTzName() {
        return this.tzName;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setViewType(ViewType viewType) {
        this.viewType = viewType;
    }

    public void setConfigDefinition(ViewConfigDefinition configDefinition) {
        this.configDefinition = configDefinition;
    }

    public void setRootEntityId(UUID rootEntityId) {
        this.rootEntityId = rootEntityId;
    }

    public void setRowClickEntityId(UUID rowClickEntityId) {
        this.rowClickEntityId = rowClickEntityId;
    }

    public void setCacheSettings(CacheSettings cacheSettings) {
        this.cacheSettings = cacheSettings;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public void setUpdatedAt(long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setSeries(List<ViewField> series) {
        this.series = series;
    }

    public void setHiddenFields(List<ViewField> hiddenFields) {
        this.hiddenFields = hiddenFields;
    }

    public void setRuntimeFilters(List<RuntimeFilterField> runtimeFilters) {
        this.runtimeFilters = runtimeFilters;
    }

    public void setSettings(JsonNode settings) {
        this.settings = settings;
    }

    public void setDatePickerConfig(DatePickerConfig datePickerConfig) {
        this.datePickerConfig = datePickerConfig;
    }

    public void setTzName(String tzName) {
        this.tzName = tzName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ViewConfig)) {
            return false;
        }
        ViewConfig other = (ViewConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ViewType this$viewType = this.getViewType();
        ViewType other$viewType = other.getViewType();
        if (this$viewType == null ? other$viewType != null : !this$viewType.equals(other$viewType)) {
            return false;
        }
        ViewConfigDefinition this$configDefinition = this.getConfigDefinition();
        ViewConfigDefinition other$configDefinition = other.getConfigDefinition();
        if (this$configDefinition == null ? other$configDefinition != null : !this$configDefinition.equals(other$configDefinition)) {
            return false;
        }
        UUID this$rootEntityId = this.getRootEntityId();
        UUID other$rootEntityId = other.getRootEntityId();
        if (this$rootEntityId == null ? other$rootEntityId != null : !((Object)this$rootEntityId).equals(other$rootEntityId)) {
            return false;
        }
        UUID this$rowClickEntityId = this.getRowClickEntityId();
        UUID other$rowClickEntityId = other.getRowClickEntityId();
        if (this$rowClickEntityId == null ? other$rowClickEntityId != null : !((Object)this$rowClickEntityId).equals(other$rowClickEntityId)) {
            return false;
        }
        CacheSettings this$cacheSettings = this.getCacheSettings();
        CacheSettings other$cacheSettings = other.getCacheSettings();
        if (this$cacheSettings == null ? other$cacheSettings != null : !this$cacheSettings.equals(other$cacheSettings)) {
            return false;
        }
        if (this.getCreatedAt() != other.getCreatedAt()) {
            return false;
        }
        if (this.getUpdatedAt() != other.getUpdatedAt()) {
            return false;
        }
        List this$xAxis = this.getxAxis();
        List other$xAxis = other.getxAxis();
        if (this$xAxis == null ? other$xAxis != null : !((Object)this$xAxis).equals(other$xAxis)) {
            return false;
        }
        List this$yAxis = this.getyAxis();
        List other$yAxis = other.getyAxis();
        if (this$yAxis == null ? other$yAxis != null : !((Object)this$yAxis).equals(other$yAxis)) {
            return false;
        }
        List this$series = this.getSeries();
        List other$series = other.getSeries();
        if (this$series == null ? other$series != null : !((Object)this$series).equals(other$series)) {
            return false;
        }
        List this$hiddenFields = this.getHiddenFields();
        List other$hiddenFields = other.getHiddenFields();
        if (this$hiddenFields == null ? other$hiddenFields != null : !((Object)this$hiddenFields).equals(other$hiddenFields)) {
            return false;
        }
        List this$runtimeFilters = this.getRuntimeFilters();
        List other$runtimeFilters = other.getRuntimeFilters();
        if (this$runtimeFilters == null ? other$runtimeFilters != null : !((Object)this$runtimeFilters).equals(other$runtimeFilters)) {
            return false;
        }
        JsonNode this$settings = this.getSettings();
        JsonNode other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !this$settings.equals(other$settings)) {
            return false;
        }
        DatePickerConfig this$datePickerConfig = this.getDatePickerConfig();
        DatePickerConfig other$datePickerConfig = other.getDatePickerConfig();
        if (this$datePickerConfig == null ? other$datePickerConfig != null : !this$datePickerConfig.equals(other$datePickerConfig)) {
            return false;
        }
        String this$tzName = this.getTzName();
        String other$tzName = other.getTzName();
        return !(this$tzName == null ? other$tzName != null : !this$tzName.equals(other$tzName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ViewConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ViewType $viewType = this.getViewType();
        result = result * 59 + ($viewType == null ? 43 : $viewType.hashCode());
        ViewConfigDefinition $configDefinition = this.getConfigDefinition();
        result = result * 59 + ($configDefinition == null ? 43 : $configDefinition.hashCode());
        UUID $rootEntityId = this.getRootEntityId();
        result = result * 59 + ($rootEntityId == null ? 43 : ((Object)$rootEntityId).hashCode());
        UUID $rowClickEntityId = this.getRowClickEntityId();
        result = result * 59 + ($rowClickEntityId == null ? 43 : ((Object)$rowClickEntityId).hashCode());
        CacheSettings $cacheSettings = this.getCacheSettings();
        result = result * 59 + ($cacheSettings == null ? 43 : $cacheSettings.hashCode());
        long $createdAt = this.getCreatedAt();
        result = result * 59 + (int)($createdAt >>> 32 ^ $createdAt);
        long $updatedAt = this.getUpdatedAt();
        result = result * 59 + (int)($updatedAt >>> 32 ^ $updatedAt);
        List $xAxis = this.getxAxis();
        result = result * 59 + ($xAxis == null ? 43 : ((Object)$xAxis).hashCode());
        List $yAxis = this.getyAxis();
        result = result * 59 + ($yAxis == null ? 43 : ((Object)$yAxis).hashCode());
        List $series = this.getSeries();
        result = result * 59 + ($series == null ? 43 : ((Object)$series).hashCode());
        List $hiddenFields = this.getHiddenFields();
        result = result * 59 + ($hiddenFields == null ? 43 : ((Object)$hiddenFields).hashCode());
        List $runtimeFilters = this.getRuntimeFilters();
        result = result * 59 + ($runtimeFilters == null ? 43 : ((Object)$runtimeFilters).hashCode());
        JsonNode $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : $settings.hashCode());
        DatePickerConfig $datePickerConfig = this.getDatePickerConfig();
        result = result * 59 + ($datePickerConfig == null ? 43 : $datePickerConfig.hashCode());
        String $tzName = this.getTzName();
        result = result * 59 + ($tzName == null ? 43 : $tzName.hashCode());
        return result;
    }

    public String toString() {
        return "ViewConfig(id=" + this.getId() + ", name=" + this.getName() + ", viewType=" + this.getViewType() + ", configDefinition=" + this.getConfigDefinition() + ", rootEntityId=" + this.getRootEntityId() + ", rowClickEntityId=" + this.getRowClickEntityId() + ", cacheSettings=" + this.getCacheSettings() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", xAxis=" + this.getxAxis() + ", yAxis=" + this.getyAxis() + ", series=" + this.getSeries() + ", hiddenFields=" + this.getHiddenFields() + ", runtimeFilters=" + this.getRuntimeFilters() + ", settings=" + this.getSettings() + ", datePickerConfig=" + this.getDatePickerConfig() + ", tzName=" + this.getTzName() + ")";
    }
}

