/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.definition.view.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.thingsboard.trendz.domain.definition.view.config.FilterCondition;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RuntimeFilterField {
    private UUID viewFieldId;
    private String name;
    private Set<String> options;
    private Set<String> selection;
    private FilterCondition condition;
    private String strParam;
    private double numericParam;
    private boolean hideInViewMode;

    @JsonIgnore
    public boolean isBlankFilter() {
        return FilterCondition.ONE_OF.equals((Object)this.condition) && CollectionUtils.isEmpty((Collection)this.selection);
    }

    public UUID getViewFieldId() {
        return this.viewFieldId;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getOptions() {
        return this.options;
    }

    public Set<String> getSelection() {
        return this.selection;
    }

    public FilterCondition getCondition() {
        return this.condition;
    }

    public String getStrParam() {
        return this.strParam;
    }

    public double getNumericParam() {
        return this.numericParam;
    }

    public boolean isHideInViewMode() {
        return this.hideInViewMode;
    }

    public void setViewFieldId(UUID viewFieldId) {
        this.viewFieldId = viewFieldId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOptions(Set<String> options) {
        this.options = options;
    }

    public void setSelection(Set<String> selection) {
        this.selection = selection;
    }

    public void setCondition(FilterCondition condition) {
        this.condition = condition;
    }

    public void setStrParam(String strParam) {
        this.strParam = strParam;
    }

    public void setNumericParam(double numericParam) {
        this.numericParam = numericParam;
    }

    public void setHideInViewMode(boolean hideInViewMode) {
        this.hideInViewMode = hideInViewMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuntimeFilterField)) {
            return false;
        }
        RuntimeFilterField other = (RuntimeFilterField)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$viewFieldId = this.getViewFieldId();
        UUID other$viewFieldId = other.getViewFieldId();
        if (this$viewFieldId == null ? other$viewFieldId != null : !((Object)this$viewFieldId).equals(other$viewFieldId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Set this$options = this.getOptions();
        Set other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        Set this$selection = this.getSelection();
        Set other$selection = other.getSelection();
        if (this$selection == null ? other$selection != null : !((Object)this$selection).equals(other$selection)) {
            return false;
        }
        FilterCondition this$condition = this.getCondition();
        FilterCondition other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        String this$strParam = this.getStrParam();
        String other$strParam = other.getStrParam();
        if (this$strParam == null ? other$strParam != null : !this$strParam.equals(other$strParam)) {
            return false;
        }
        if (Double.compare(this.getNumericParam(), other.getNumericParam()) != 0) {
            return false;
        }
        return this.isHideInViewMode() == other.isHideInViewMode();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RuntimeFilterField;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $viewFieldId = this.getViewFieldId();
        result = result * 59 + ($viewFieldId == null ? 43 : ((Object)$viewFieldId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Set $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        Set $selection = this.getSelection();
        result = result * 59 + ($selection == null ? 43 : ((Object)$selection).hashCode());
        FilterCondition $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        String $strParam = this.getStrParam();
        result = result * 59 + ($strParam == null ? 43 : $strParam.hashCode());
        long $numericParam = Double.doubleToLongBits(this.getNumericParam());
        result = result * 59 + (int)($numericParam >>> 32 ^ $numericParam);
        result = result * 59 + (this.isHideInViewMode() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "RuntimeFilterField(viewFieldId=" + this.getViewFieldId() + ", name=" + this.getName() + ", options=" + this.getOptions() + ", selection=" + this.getSelection() + ", condition=" + this.getCondition() + ", strParam=" + this.getStrParam() + ", numericParam=" + this.getNumericParam() + ", hideInViewMode=" + this.isHideInViewMode() + ")";
    }
}

