/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.definition.view.config;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalField;
import org.apache.commons.lang3.tuple.Pair;
import org.thingsboard.trendz.domain.definition.view.config.DateFormatUtil;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfigSelectType;

public class DatePickerConfig {
    private long startTs;
    private long endTs;
    private DatePickerConfigSelectType selectedType;
    private DatePickerConfigSelectType selectedUnit;
    private String relativeUnit;
    private int relativeLastAmount;
    private String rangeBy;
    private int rangeByAmount;

    public Pair<Long, Long> buildStartEndPair(String tz) {
        if (this.selectedType != null && "relative".equals(this.selectedType.getValue())) {
            long localEnd;
            long localStart;
            String unitValue = this.selectedUnit.getValue();
            TemporalField temporalField = null;
            long currentTs = System.currentTimeMillis();
            switch (unitValue) {
                case "year": {
                    temporalField = ChronoField.DAY_OF_YEAR;
                    break;
                }
                case "quarter": {
                    temporalField = IsoFields.DAY_OF_QUARTER;
                    break;
                }
                case "month": {
                    temporalField = ChronoField.DAY_OF_MONTH;
                    break;
                }
                case "week": {
                    temporalField = ChronoField.DAY_OF_WEEK;
                    break;
                }
                case "day": {
                    temporalField = ChronoField.HOUR_OF_DAY;
                    break;
                }
                default: {
                    throw new IllegalStateException("Date picker unit not supported : " + unitValue);
                }
            }
            ZoneId zoneId = DateFormatUtil.parseZone((String)tz);
            switch (this.relativeUnit) {
                case "prev": {
                    localStart = ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentTs), zoneId).with(temporalField, 1L).truncatedTo(ChronoUnit.DAYS).minus(1L, temporalField.getRangeUnit()).toEpochSecond() * 1000L;
                    localEnd = ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentTs), zoneId).with(temporalField, 1L).truncatedTo(ChronoUnit.DAYS).toEpochSecond() * 1000L - 1L;
                    break;
                }
                case "this": {
                    localStart = ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentTs), zoneId).with(temporalField, 1L).truncatedTo(ChronoUnit.DAYS).toEpochSecond() * 1000L;
                    localEnd = currentTs;
                    break;
                }
                case "last": {
                    localStart = ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentTs), zoneId).with(temporalField, 1L).truncatedTo(ChronoUnit.DAYS).minus(this.relativeLastAmount - 1, temporalField.getRangeUnit()).toEpochSecond() * 1000L;
                    localEnd = currentTs;
                    break;
                }
                default: {
                    throw new IllegalStateException("Date picker relative unit not supported : " + this.relativeUnit);
                }
            }
            return Pair.of((Object)localStart, (Object)localEnd);
        }
        return Pair.of((Object)this.startTs, (Object)this.endTs);
    }

    public long getStartTs() {
        return this.startTs;
    }

    public long getEndTs() {
        return this.endTs;
    }

    public DatePickerConfigSelectType getSelectedType() {
        return this.selectedType;
    }

    public DatePickerConfigSelectType getSelectedUnit() {
        return this.selectedUnit;
    }

    public String getRelativeUnit() {
        return this.relativeUnit;
    }

    public int getRelativeLastAmount() {
        return this.relativeLastAmount;
    }

    public String getRangeBy() {
        return this.rangeBy;
    }

    public int getRangeByAmount() {
        return this.rangeByAmount;
    }

    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    public void setEndTs(long endTs) {
        this.endTs = endTs;
    }

    public void setSelectedType(DatePickerConfigSelectType selectedType) {
        this.selectedType = selectedType;
    }

    public void setSelectedUnit(DatePickerConfigSelectType selectedUnit) {
        this.selectedUnit = selectedUnit;
    }

    public void setRelativeUnit(String relativeUnit) {
        this.relativeUnit = relativeUnit;
    }

    public void setRelativeLastAmount(int relativeLastAmount) {
        this.relativeLastAmount = relativeLastAmount;
    }

    public void setRangeBy(String rangeBy) {
        this.rangeBy = rangeBy;
    }

    public void setRangeByAmount(int rangeByAmount) {
        this.rangeByAmount = rangeByAmount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatePickerConfig)) {
            return false;
        }
        DatePickerConfig other = (DatePickerConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.getEndTs() != other.getEndTs()) {
            return false;
        }
        DatePickerConfigSelectType this$selectedType = this.getSelectedType();
        DatePickerConfigSelectType other$selectedType = other.getSelectedType();
        if (this$selectedType == null ? other$selectedType != null : !this$selectedType.equals(other$selectedType)) {
            return false;
        }
        DatePickerConfigSelectType this$selectedUnit = this.getSelectedUnit();
        DatePickerConfigSelectType other$selectedUnit = other.getSelectedUnit();
        if (this$selectedUnit == null ? other$selectedUnit != null : !this$selectedUnit.equals(other$selectedUnit)) {
            return false;
        }
        String this$relativeUnit = this.getRelativeUnit();
        String other$relativeUnit = other.getRelativeUnit();
        if (this$relativeUnit == null ? other$relativeUnit != null : !this$relativeUnit.equals(other$relativeUnit)) {
            return false;
        }
        if (this.getRelativeLastAmount() != other.getRelativeLastAmount()) {
            return false;
        }
        String this$rangeBy = this.getRangeBy();
        String other$rangeBy = other.getRangeBy();
        if (this$rangeBy == null ? other$rangeBy != null : !this$rangeBy.equals(other$rangeBy)) {
            return false;
        }
        return this.getRangeByAmount() == other.getRangeByAmount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DatePickerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $endTs = this.getEndTs();
        result = result * 59 + (int)($endTs >>> 32 ^ $endTs);
        DatePickerConfigSelectType $selectedType = this.getSelectedType();
        result = result * 59 + ($selectedType == null ? 43 : $selectedType.hashCode());
        DatePickerConfigSelectType $selectedUnit = this.getSelectedUnit();
        result = result * 59 + ($selectedUnit == null ? 43 : $selectedUnit.hashCode());
        String $relativeUnit = this.getRelativeUnit();
        result = result * 59 + ($relativeUnit == null ? 43 : $relativeUnit.hashCode());
        result = result * 59 + this.getRelativeLastAmount();
        String $rangeBy = this.getRangeBy();
        result = result * 59 + ($rangeBy == null ? 43 : $rangeBy.hashCode());
        result = result * 59 + this.getRangeByAmount();
        return result;
    }

    public String toString() {
        return "DatePickerConfig(startTs=" + this.getStartTs() + ", endTs=" + this.getEndTs() + ", selectedType=" + this.getSelectedType() + ", selectedUnit=" + this.getSelectedUnit() + ", relativeUnit=" + this.getRelativeUnit() + ", relativeLastAmount=" + this.getRelativeLastAmount() + ", rangeBy=" + this.getRangeBy() + ", rangeByAmount=" + this.getRangeByAmount() + ")";
    }
}

