/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.definition.view.config;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateFormatUtil {
    private static final Logger log = LoggerFactory.getLogger(DateFormatUtil.class);

    public static String truncateMinute(long ts, int amount, String tzName) {
        ZonedDateTime time = ZonedDateTime.ofInstant(Instant.ofEpochMilli(ts), DateFormatUtil.parseZone((String)tzName));
        return "" + time.truncatedTo(ChronoUnit.HOURS).plusMinutes(amount * (time.getMinute() / amount)).toEpochSecond() * 1000L;
    }

    public static String truncateHour(long ts, int amount, String tzName) {
        ZonedDateTime time = ZonedDateTime.ofInstant(Instant.ofEpochMilli(ts), DateFormatUtil.parseZone((String)tzName));
        return "" + time.truncatedTo(ChronoUnit.DAYS).plusHours(amount * (time.getHour() / amount)).toEpochSecond() * 1000L;
    }

    public static String truncateDay(long ts, int amount, String tzName) {
        ZonedDateTime time = ZonedDateTime.ofInstant(Instant.ofEpochMilli(ts), DateFormatUtil.parseZone((String)tzName));
        int plusDays = amount * (time.getDayOfMonth() / amount);
        if (plusDays > 0) {
            --plusDays;
        }
        return "" + time.truncatedTo(ChronoUnit.DAYS).with(ChronoField.DAY_OF_MONTH, 1L).plusDays(plusDays).toEpochSecond() * 1000L;
    }

    public static String truncateWeek(long ts, int amount, String tzName) {
        ZonedDateTime time = ZonedDateTime.ofInstant(Instant.ofEpochMilli(ts), DateFormatUtil.parseZone((String)tzName));
        return "" + time.truncatedTo(ChronoUnit.DAYS).with(ChronoField.DAY_OF_YEAR, 1L).plusWeeks(amount * (time.getDayOfYear() / 7 / amount)).with(ChronoField.DAY_OF_WEEK, 1L).toEpochSecond() * 1000L;
    }

    public static String truncateMonth(long ts, int amount, String tzName) {
        ZonedDateTime time = ZonedDateTime.ofInstant(Instant.ofEpochMilli(ts), DateFormatUtil.parseZone((String)tzName));
        int plusMonth = amount * (time.getMonth().getValue() / amount);
        if (plusMonth > 0) {
            --plusMonth;
        }
        return "" + time.truncatedTo(ChronoUnit.DAYS).with(ChronoField.DAY_OF_YEAR, 1L).plusMonths(plusMonth).toEpochSecond() * 1000L;
    }

    public static ZoneId parseZone(String rawName) {
        try {
            return StringUtils.isBlank((CharSequence)rawName) ? ZoneId.systemDefault() : ZoneId.of(rawName);
        }
        catch (RuntimeException re) {
            log.warn("Can not parse timezone name " + rawName, (Throwable)re);
            return ZoneId.systemDefault();
        }
    }
}

