/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.definition.view.config;

import com.google.common.collect.Sets;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.time.temporal.WeekFields;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.NotImplementedException;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.DateFormatUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public enum DateAggregationType {
    RAW("H"),
    MINUTE("mm"),
    FULL_HOUR("yyyy-MM-dd HH"),
    HOUR("HH"),
    FULL_DATE("yyyy-MM-dd"),
    DAY("e"),
    DATE("dd"),
    START_OF_WEEK("yyyy-MM-dd"),
    WEEK_OF_YEAR("ww"),
    WEEK_OF_MONTH("W"),
    MONTH("MM"),
    QUARTER("'Q'Q"),
    YEAR("yyyy"),
    YEARMONTH("yyyy-MMM");

    private DateTimeFormatter formatter;

    private DateAggregationType(String pattern) {
        this.formatter = DateTimeFormatter.ofPattern(pattern, Locale.getDefault());
    }

    public String apply(long ts, String tzName) {
        LocalDateTime parse;
        if (RAW.equals((Object)this)) {
            return "" + ts;
        }
        if (START_OF_WEEK.equals((Object)this)) {
            ts = Long.parseLong(DateFormatUtil.truncateWeek((long)ts, (int)1, (String)tzName));
        } else if (DAY.equals((Object)this)) {
            parse = DateAggregationType.parse((long)ts, (String)tzName);
            if (DayOfWeek.SUNDAY.equals(WeekFields.of(Locale.getDefault()).getFirstDayOfWeek())) {
                return "" + parse.getDayOfWeek().getValue();
            }
        }
        parse = DateAggregationType.parse((long)ts, (String)tzName);
        return parse.format(this.formatter.withZone(DateFormatUtil.parseZone((String)tzName)));
    }

    private static LocalDateTime parse(long ts, String tzName) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(ts), DateFormatUtil.parseZone((String)tzName));
    }

    public static long duration(DateAggregationType type) {
        switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$DateAggregationType[type.ordinal()]) {
            case 1: {
                return TimeUnit.MINUTES.toMillis(1L);
            }
            case 2: 
            case 3: {
                return TimeUnit.HOURS.toMillis(1L);
            }
            case 4: 
            case 5: 
            case 6: {
                return TimeUnit.DAYS.toMillis(1L);
            }
            case 7: 
            case 8: {
                return TimeUnit.DAYS.toMillis(7L);
            }
            case 9: 
            case 10: 
            case 11: {
                return TimeUnit.DAYS.toMillis(30L);
            }
            case 12: {
                return TimeUnit.DAYS.toMillis(90L);
            }
            case 13: {
                return TimeUnit.DAYS.toMillis(365L);
            }
        }
        return Long.MAX_VALUE;
    }

    public static ZonedDateTime extendedTruncateTo(ZonedDateTime date, TemporalUnit truncateUnit) {
        ChronoUnit truncateChronoUnit = (ChronoUnit)truncateUnit;
        switch (1.$SwitchMap$java$time$temporal$ChronoUnit[truncateChronoUnit.ordinal()]) {
            case 1: {
                return date.truncatedTo(ChronoUnit.DAYS).with(ChronoField.DAY_OF_WEEK, 1L);
            }
            case 2: {
                return date.truncatedTo(ChronoUnit.DAYS).with(ChronoField.DAY_OF_MONTH, 1L);
            }
            case 3: {
                return date.truncatedTo(ChronoUnit.DAYS).with(ChronoField.DAY_OF_YEAR, 1L);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                throw new NotImplementedException();
            }
            case 8: {
                throw new IllegalArgumentException("Impossible!");
            }
        }
        return date.truncatedTo(truncateUnit);
    }

    public static ChronoUnit mapDateAggregationToChronoUnit(DateAggregationType dateAggregationType) {
        switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$DateAggregationType[dateAggregationType.ordinal()]) {
            case 1: {
                return ChronoUnit.MINUTES;
            }
            case 2: 
            case 3: {
                return ChronoUnit.HOURS;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return ChronoUnit.DAYS;
            }
            case 7: 
            case 9: {
                return ChronoUnit.WEEKS;
            }
            case 10: 
            case 11: 
            case 12: {
                return ChronoUnit.MONTHS;
            }
            case 13: {
                return ChronoUnit.YEARS;
            }
        }
        throw new IllegalArgumentException("DateAggregationType is not supported: " + dateAggregationType);
    }

    public static DateAggregationType getEqualByDurationForCaching(DateAggregationType type) {
        switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$DateAggregationType[type.ordinal()]) {
            case 2: 
            case 3: {
                return FULL_HOUR;
            }
            case 4: 
            case 5: 
            case 6: {
                return FULL_DATE;
            }
        }
        throw new IllegalArgumentException("Unsupported DateAggregationType: " + type);
    }

    public static DateAggregationType getFullType(DateAggregationType type) {
        if (type == null) {
            return null;
        }
        switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$DateAggregationType[type.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                return FULL_HOUR;
            }
            case 4: 
            case 5: 
            case 6: {
                return FULL_DATE;
            }
            case 7: 
            case 8: {
                return WEEK_OF_YEAR;
            }
            case 9: 
            case 10: 
            case 11: {
                return YEARMONTH;
            }
            case 12: {
                return QUARTER;
            }
            case 13: {
                return YEAR;
            }
        }
        throw new IllegalArgumentException("Unsupported DateAggregationType: " + type);
    }

    public static boolean isLoadableAggregationType(DateAggregationType type) {
        if (type == null) {
            return true;
        }
        return !Sets.newHashSet((Object[])new DateAggregationType[]{RAW, MINUTE}).contains(type);
    }
}

