/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.definition.entity.relation;

import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;
import org.thingsboard.trendz.domain.definition.entity.relation.RelationGraph;
import org.thingsboard.trendz.domain.definition.entity.relation.RelationNode;

/*
 * Exception performing whole class analysis ignored.
 */
public class RelationUtils {
    private static final Logger log = LoggerFactory.getLogger(RelationUtils.class);

    public static Set<UUID> findMissedNodes(RelationGraph graph, Set<UUID> entityIds, UUID rootId) {
        if (entityIds.size() < 2) {
            return Collections.emptySet();
        }
        HashSet originalIds = Sets.newHashSet(entityIds);
        if (rootId != null) {
            originalIds.add(rootId);
        }
        HashSet<UUID> requiredEntityIds = new HashSet<UUID>();
        for (UUID entityId : originalIds) {
            requiredEntityIds.add(entityId);
            RelationGraph tmpGraph = graph.copy();
            RelationNode potentialRoot = tmpGraph.getNodeById(entityId);
            RelationUtils.calculateShortestPathFromSource((RelationNode)potentialRoot);
            for (UUID otherEntityId : originalIds) {
                if (otherEntityId == entityId) continue;
                tmpGraph.getNodeById(otherEntityId).getShortestPath().forEach(rn -> requiredEntityIds.add(rn.getEntityId()));
            }
        }
        if (rootId != null) {
            requiredEntityIds.add(rootId);
        }
        return Sets.difference(requiredEntityIds, entityIds);
    }

    public static UUID findDefaultRoot(RelationGraph graph, Set<UUID> entityIds) {
        if (entityIds.size() == 1) {
            return entityIds.iterator().next();
        }
        TreeMultimap nodeCount = TreeMultimap.create();
        for (UUID id : entityIds) {
            RelationNode node = graph.getNodeById(id);
            nodeCount.put((Object)node.getAdjacentNodes().size(), (Object)id);
        }
        NavigableSet minNodes = nodeCount.get(nodeCount.keySet().iterator().next());
        return (UUID)minNodes.iterator().next();
    }

    public static void calculateShortestPathFromSource(RelationNode source) {
        source.setDistance(0);
        HashSet<RelationNode> settledNodes = new HashSet<RelationNode>();
        HashSet<RelationNode> unsettledNodes = new HashSet<RelationNode>();
        unsettledNodes.add(source);
        while (unsettledNodes.size() != 0) {
            RelationNode currentNode = RelationUtils.getLowestDistanceNode(unsettledNodes);
            unsettledNodes.remove(currentNode);
            for (Map.Entry adjacencyPair : currentNode.getAdjacentNodes().entrySet()) {
                RelationNode adjacentNode = (RelationNode)adjacencyPair.getKey();
                Relation edgeWeight = (Relation)adjacencyPair.getValue();
                if (settledNodes.contains(adjacentNode)) continue;
                RelationUtils.calculateMinimumDistance((RelationNode)adjacentNode, (Integer)edgeWeight.getQuery().getDistance(), (RelationNode)currentNode);
                unsettledNodes.add(adjacentNode);
            }
            settledNodes.add(currentNode);
        }
    }

    private static RelationNode getLowestDistanceNode(Set<RelationNode> unsettledNodes) {
        RelationNode lowestDistanceNode = null;
        int lowestDistance = Integer.MAX_VALUE;
        for (RelationNode node : unsettledNodes) {
            int nodeDistance = node.getDistance();
            if (nodeDistance >= lowestDistance) continue;
            lowestDistance = nodeDistance;
            lowestDistanceNode = node;
        }
        return lowestDistanceNode;
    }

    private static void calculateMinimumDistance(RelationNode evaluationNode, Integer edgeWeigh, RelationNode sourceNode) {
        Integer sourceDistance = sourceNode.getDistance();
        if (sourceDistance + edgeWeigh < evaluationNode.getDistance()) {
            evaluationNode.setDistance(sourceDistance + edgeWeigh);
            LinkedList<RelationNode> shortestPath = new LinkedList<RelationNode>(sourceNode.getShortestPath());
            shortestPath.add(sourceNode);
            evaluationNode.setShortestPath(shortestPath);
        }
    }
}

