/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.definition.entity.relation;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;

public class RelationNode {
    private UUID entityId;
    private String entityName;
    private int distance = Integer.MAX_VALUE;
    private List<RelationNode> shortestPath = new LinkedList();
    private Map<RelationNode, Relation> adjacentNodes = new HashMap();

    public RelationNode(UUID entityId, String name) {
        this.entityId = entityId;
        this.entityName = name;
    }

    public void addDestination(RelationNode destination, Relation relation) {
        this.adjacentNodes.put(destination, relation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationNode that = (RelationNode)o;
        return new EqualsBuilder().append((Object)this.entityId, (Object)that.entityId).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.entityId).toHashCode();
    }

    public UUID getEntityId() {
        return this.entityId;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public int getDistance() {
        return this.distance;
    }

    public List<RelationNode> getShortestPath() {
        return this.shortestPath;
    }

    public Map<RelationNode, Relation> getAdjacentNodes() {
        return this.adjacentNodes;
    }

    public void setEntityId(UUID entityId) {
        this.entityId = entityId;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public void setDistance(int distance) {
        this.distance = distance;
    }

    public void setShortestPath(List<RelationNode> shortestPath) {
        this.shortestPath = shortestPath;
    }

    public void setAdjacentNodes(Map<RelationNode, Relation> adjacentNodes) {
        this.adjacentNodes = adjacentNodes;
    }

    public String toString() {
        return "RelationNode(entityId=" + this.getEntityId() + ", entityName=" + this.getEntityName() + ", distance=" + this.getDistance() + ", shortestPath=" + this.getShortestPath() + ", adjacentNodes=" + this.getAdjacentNodes() + ")";
    }
}

