/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.definition.entity.relation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;
import org.thingsboard.trendz.domain.definition.entity.relation.RelationNode;

public class RelationGraph {
    private Set<RelationNode> nodes = new HashSet();

    public void addNode(RelationNode node) {
        this.nodes.add(node);
    }

    public RelationNode getNodeById(UUID id) {
        for (RelationNode node : this.nodes) {
            if (!node.getEntityId().equals(id)) continue;
            return node;
        }
        return null;
    }

    public RelationGraph copy() {
        HashMap<UUID, RelationNode> nodesMap = new HashMap<UUID, RelationNode>();
        for (RelationNode node : this.nodes) {
            nodesMap.put(node.getEntityId(), new RelationNode(node.getEntityId(), node.getEntityName()));
        }
        RelationGraph graphCopy = new RelationGraph();
        for (RelationNode node : this.nodes) {
            RelationNode copyNode = (RelationNode)nodesMap.get(node.getEntityId());
            for (RelationNode relationNode : node.getAdjacentNodes().keySet()) {
                copyNode.addDestination((RelationNode)nodesMap.get(relationNode.getEntityId()), (Relation)node.getAdjacentNodes().get(relationNode));
            }
            graphCopy.addNode(copyNode);
        }
        return graphCopy;
    }
}

