/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.definition.entity.field;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.UUID;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityFieldQuery;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.entity.field.TbBusinessEntityFieldQuery;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BusinessEntityField {
    private UUID id;
    private UUID businessEntityId;
    private String name;
    private String description;
    private boolean hidden;
    private Set<String> options;
    private String calcFunction;
    private FieldType type;
    @JsonDeserialize(as=TbBusinessEntityFieldQuery.class)
    private BusinessEntityFieldQuery query;

    public boolean hasTime() {
        return this.query != null && Sets.newHashSet((Object[])new FieldQueryType[]{FieldQueryType.STATE, FieldQueryType.CALCULATED, FieldQueryType.TELEMETRY}).contains(this.query.getQueryType());
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getBusinessEntityId() {
        return this.businessEntityId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Set<String> getOptions() {
        return this.options;
    }

    public String getCalcFunction() {
        return this.calcFunction;
    }

    public FieldType getType() {
        return this.type;
    }

    public BusinessEntityFieldQuery getQuery() {
        return this.query;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setBusinessEntityId(UUID businessEntityId) {
        this.businessEntityId = businessEntityId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setOptions(Set<String> options) {
        this.options = options;
    }

    public void setCalcFunction(String calcFunction) {
        this.calcFunction = calcFunction;
    }

    public void setType(FieldType type) {
        this.type = type;
    }

    public void setQuery(BusinessEntityFieldQuery query) {
        this.query = query;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessEntityField)) {
            return false;
        }
        BusinessEntityField other = (BusinessEntityField)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$businessEntityId = this.getBusinessEntityId();
        UUID other$businessEntityId = other.getBusinessEntityId();
        if (this$businessEntityId == null ? other$businessEntityId != null : !((Object)this$businessEntityId).equals(other$businessEntityId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        if (this.isHidden() != other.isHidden()) {
            return false;
        }
        Set this$options = this.getOptions();
        Set other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        String this$calcFunction = this.getCalcFunction();
        String other$calcFunction = other.getCalcFunction();
        if (this$calcFunction == null ? other$calcFunction != null : !this$calcFunction.equals(other$calcFunction)) {
            return false;
        }
        FieldType this$type = this.getType();
        FieldType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        BusinessEntityFieldQuery this$query = this.getQuery();
        BusinessEntityFieldQuery other$query = other.getQuery();
        return !(this$query == null ? other$query != null : !this$query.equals(other$query));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BusinessEntityField;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $businessEntityId = this.getBusinessEntityId();
        result = result * 59 + ($businessEntityId == null ? 43 : ((Object)$businessEntityId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        result = result * 59 + (this.isHidden() ? 79 : 97);
        Set $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        String $calcFunction = this.getCalcFunction();
        result = result * 59 + ($calcFunction == null ? 43 : $calcFunction.hashCode());
        FieldType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        BusinessEntityFieldQuery $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        return result;
    }

    public String toString() {
        return "BusinessEntityField(id=" + this.getId() + ", businessEntityId=" + this.getBusinessEntityId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", hidden=" + this.isHidden() + ", options=" + this.getOptions() + ", calcFunction=" + this.getCalcFunction() + ", type=" + this.getType() + ", query=" + this.getQuery() + ")";
    }
}

