/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.cache;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.thingsboard.trendz.domain.cache.CachedTelemetryPoint;

public class CachedTelemetryPoint {
    private long ts;
    private Object value;

    public CachedTelemetryPoint(CachedTelemetryPoint that) {
        this.ts = that.ts;
        this.value = that.value;
    }

    public String toString() {
        return "CachedTelemetryPoint(ts = " + this.ts + " [" + ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.ts), ZoneId.systemDefault()) + "], value = " + this.value + ")";
    }

    public static CachedTelemetryPointBuilder builder() {
        return new CachedTelemetryPointBuilder();
    }

    public long getTs() {
        return this.ts;
    }

    public Object getValue() {
        return this.value;
    }

    public void setTs(long ts) {
        this.ts = ts;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CachedTelemetryPoint)) {
            return false;
        }
        CachedTelemetryPoint other = (CachedTelemetryPoint)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getTs() != other.getTs()) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CachedTelemetryPoint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $ts = this.getTs();
        result = result * 59 + (int)($ts >>> 32 ^ $ts);
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public CachedTelemetryPoint() {
    }

    public CachedTelemetryPoint(long ts, Object value) {
        this.ts = ts;
        this.value = value;
    }
}

