/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.cache;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.thingsboard.trendz.domain.cache.CachedTelemetry;
import org.thingsboard.trendz.domain.cache.CachedTelemetryPoint;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;

public class CachedTelemetry {
    private UUID id;
    private UUID itemId;
    private UUID tenantId;
    private long uploadTime;
    private boolean calculatedField;
    private boolean stateField;
    private long startTs;
    private long endTs;
    private FieldType fieldType;
    private FieldAggregation fieldAggregation;
    private DateAggregationType dateAggregationType;
    private UUID businessEntityId;
    private UUID businessEntityFieldId;
    private String calculatedOrStateFunction;
    private List<CachedTelemetryPoint> points;

    public CachedTelemetry(CachedTelemetry that) {
        this.id = that.id;
        this.itemId = that.itemId;
        this.tenantId = that.tenantId;
        this.uploadTime = that.uploadTime;
        this.calculatedField = that.calculatedField;
        this.stateField = that.stateField;
        this.startTs = that.startTs;
        this.endTs = that.endTs;
        this.fieldType = that.fieldType;
        this.fieldAggregation = that.fieldAggregation;
        this.dateAggregationType = that.dateAggregationType;
        this.businessEntityId = that.businessEntityId;
        this.businessEntityFieldId = that.businessEntityFieldId;
        this.calculatedOrStateFunction = that.calculatedOrStateFunction;
        this.points = that.getPoints() == null ? null : that.getPoints().stream().map(CachedTelemetryPoint::new).collect(Collectors.toList());
    }

    public static CachedTelemetryBuilder builder() {
        return new CachedTelemetryBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getItemId() {
        return this.itemId;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public long getUploadTime() {
        return this.uploadTime;
    }

    public boolean isCalculatedField() {
        return this.calculatedField;
    }

    public boolean isStateField() {
        return this.stateField;
    }

    public long getStartTs() {
        return this.startTs;
    }

    public long getEndTs() {
        return this.endTs;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public FieldAggregation getFieldAggregation() {
        return this.fieldAggregation;
    }

    public DateAggregationType getDateAggregationType() {
        return this.dateAggregationType;
    }

    public UUID getBusinessEntityId() {
        return this.businessEntityId;
    }

    public UUID getBusinessEntityFieldId() {
        return this.businessEntityFieldId;
    }

    public String getCalculatedOrStateFunction() {
        return this.calculatedOrStateFunction;
    }

    public List<CachedTelemetryPoint> getPoints() {
        return this.points;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setItemId(UUID itemId) {
        this.itemId = itemId;
    }

    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    public void setUploadTime(long uploadTime) {
        this.uploadTime = uploadTime;
    }

    public void setCalculatedField(boolean calculatedField) {
        this.calculatedField = calculatedField;
    }

    public void setStateField(boolean stateField) {
        this.stateField = stateField;
    }

    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    public void setEndTs(long endTs) {
        this.endTs = endTs;
    }

    public void setFieldType(FieldType fieldType) {
        this.fieldType = fieldType;
    }

    public void setFieldAggregation(FieldAggregation fieldAggregation) {
        this.fieldAggregation = fieldAggregation;
    }

    public void setDateAggregationType(DateAggregationType dateAggregationType) {
        this.dateAggregationType = dateAggregationType;
    }

    public void setBusinessEntityId(UUID businessEntityId) {
        this.businessEntityId = businessEntityId;
    }

    public void setBusinessEntityFieldId(UUID businessEntityFieldId) {
        this.businessEntityFieldId = businessEntityFieldId;
    }

    public void setCalculatedOrStateFunction(String calculatedOrStateFunction) {
        this.calculatedOrStateFunction = calculatedOrStateFunction;
    }

    public void setPoints(List<CachedTelemetryPoint> points) {
        this.points = points;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CachedTelemetry)) {
            return false;
        }
        CachedTelemetry other = (CachedTelemetry)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$itemId = this.getItemId();
        UUID other$itemId = other.getItemId();
        if (this$itemId == null ? other$itemId != null : !((Object)this$itemId).equals(other$itemId)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        if (this.getUploadTime() != other.getUploadTime()) {
            return false;
        }
        if (this.isCalculatedField() != other.isCalculatedField()) {
            return false;
        }
        if (this.isStateField() != other.isStateField()) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.getEndTs() != other.getEndTs()) {
            return false;
        }
        FieldType this$fieldType = this.getFieldType();
        FieldType other$fieldType = other.getFieldType();
        if (this$fieldType == null ? other$fieldType != null : !this$fieldType.equals(other$fieldType)) {
            return false;
        }
        FieldAggregation this$fieldAggregation = this.getFieldAggregation();
        FieldAggregation other$fieldAggregation = other.getFieldAggregation();
        if (this$fieldAggregation == null ? other$fieldAggregation != null : !this$fieldAggregation.equals(other$fieldAggregation)) {
            return false;
        }
        DateAggregationType this$dateAggregationType = this.getDateAggregationType();
        DateAggregationType other$dateAggregationType = other.getDateAggregationType();
        if (this$dateAggregationType == null ? other$dateAggregationType != null : !this$dateAggregationType.equals(other$dateAggregationType)) {
            return false;
        }
        UUID this$businessEntityId = this.getBusinessEntityId();
        UUID other$businessEntityId = other.getBusinessEntityId();
        if (this$businessEntityId == null ? other$businessEntityId != null : !((Object)this$businessEntityId).equals(other$businessEntityId)) {
            return false;
        }
        UUID this$businessEntityFieldId = this.getBusinessEntityFieldId();
        UUID other$businessEntityFieldId = other.getBusinessEntityFieldId();
        if (this$businessEntityFieldId == null ? other$businessEntityFieldId != null : !((Object)this$businessEntityFieldId).equals(other$businessEntityFieldId)) {
            return false;
        }
        String this$calculatedOrStateFunction = this.getCalculatedOrStateFunction();
        String other$calculatedOrStateFunction = other.getCalculatedOrStateFunction();
        if (this$calculatedOrStateFunction == null ? other$calculatedOrStateFunction != null : !this$calculatedOrStateFunction.equals(other$calculatedOrStateFunction)) {
            return false;
        }
        List this$points = this.getPoints();
        List other$points = other.getPoints();
        return !(this$points == null ? other$points != null : !((Object)this$points).equals(other$points));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CachedTelemetry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $itemId = this.getItemId();
        result = result * 59 + ($itemId == null ? 43 : ((Object)$itemId).hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        long $uploadTime = this.getUploadTime();
        result = result * 59 + (int)($uploadTime >>> 32 ^ $uploadTime);
        result = result * 59 + (this.isCalculatedField() ? 79 : 97);
        result = result * 59 + (this.isStateField() ? 79 : 97);
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $endTs = this.getEndTs();
        result = result * 59 + (int)($endTs >>> 32 ^ $endTs);
        FieldType $fieldType = this.getFieldType();
        result = result * 59 + ($fieldType == null ? 43 : $fieldType.hashCode());
        FieldAggregation $fieldAggregation = this.getFieldAggregation();
        result = result * 59 + ($fieldAggregation == null ? 43 : $fieldAggregation.hashCode());
        DateAggregationType $dateAggregationType = this.getDateAggregationType();
        result = result * 59 + ($dateAggregationType == null ? 43 : $dateAggregationType.hashCode());
        UUID $businessEntityId = this.getBusinessEntityId();
        result = result * 59 + ($businessEntityId == null ? 43 : ((Object)$businessEntityId).hashCode());
        UUID $businessEntityFieldId = this.getBusinessEntityFieldId();
        result = result * 59 + ($businessEntityFieldId == null ? 43 : ((Object)$businessEntityFieldId).hashCode());
        String $calculatedOrStateFunction = this.getCalculatedOrStateFunction();
        result = result * 59 + ($calculatedOrStateFunction == null ? 43 : $calculatedOrStateFunction.hashCode());
        List $points = this.getPoints();
        result = result * 59 + ($points == null ? 43 : ((Object)$points).hashCode());
        return result;
    }

    public String toString() {
        return "CachedTelemetry(id=" + this.getId() + ", itemId=" + this.getItemId() + ", tenantId=" + this.getTenantId() + ", uploadTime=" + this.getUploadTime() + ", calculatedField=" + this.isCalculatedField() + ", stateField=" + this.isStateField() + ", startTs=" + this.getStartTs() + ", endTs=" + this.getEndTs() + ", fieldType=" + this.getFieldType() + ", fieldAggregation=" + this.getFieldAggregation() + ", dateAggregationType=" + this.getDateAggregationType() + ", businessEntityId=" + this.getBusinessEntityId() + ", businessEntityFieldId=" + this.getBusinessEntityFieldId() + ", calculatedOrStateFunction=" + this.getCalculatedOrStateFunction() + ", points=" + this.getPoints() + ")";
    }

    public CachedTelemetry() {
    }

    public CachedTelemetry(UUID id, UUID itemId, UUID tenantId, long uploadTime, boolean calculatedField, boolean stateField, long startTs, long endTs, FieldType fieldType, FieldAggregation fieldAggregation, DateAggregationType dateAggregationType, UUID businessEntityId, UUID businessEntityFieldId, String calculatedOrStateFunction, List<CachedTelemetryPoint> points) {
        this.id = id;
        this.itemId = itemId;
        this.tenantId = tenantId;
        this.uploadTime = uploadTime;
        this.calculatedField = calculatedField;
        this.stateField = stateField;
        this.startTs = startTs;
        this.endTs = endTs;
        this.fieldType = fieldType;
        this.fieldAggregation = fieldAggregation;
        this.dateAggregationType = dateAggregationType;
        this.businessEntityId = businessEntityId;
        this.businessEntityFieldId = businessEntityFieldId;
        this.calculatedOrStateFunction = calculatedOrStateFunction;
        this.points = points;
    }
}

