/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.builder.view;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.sql.TimeStampUUIDGenerator;
import org.thingsboard.trendz.domain.builder.view.RuntimeFilterBuilder;
import org.thingsboard.trendz.domain.builder.view.ViewFieldBuilder;
import org.thingsboard.trendz.domain.builder.view.ViewFieldBuilderFactory;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.service.definition.BusinessEntityService;

@Service
public class ViewFieldBuilderFactory {
    private static final Logger log = LoggerFactory.getLogger(ViewFieldBuilderFactory.class);
    @Autowired
    private BusinessEntityService businessEntityService;

    public ViewField processViewField(ViewFieldBuilder viewFieldBuilder) {
        switch (1.$SwitchMap$org$thingsboard$trendz$domain$builder$view$ViewFieldBuilderType[viewFieldBuilder.getViewFieldType().ordinal()]) {
            case 1: {
                return this.createDateViewField(viewFieldBuilder);
            }
            case 2: {
                return this.createStateViewField(viewFieldBuilder);
            }
            case 3: {
                return this.createCalculatedViewField(viewFieldBuilder);
            }
            case 4: 
            case 5: {
                return this.createAttributeOrTelemetryViewField(viewFieldBuilder);
            }
        }
        throw new IllegalArgumentException("Unknown View Field type: " + viewFieldBuilder.getViewFieldType());
    }

    public void processRuntimeFilterField(List<ViewField> outputHiddenFields, List<RuntimeFilterField> outputRuntimeFilterFields, RuntimeFilterBuilder filterBuilder, List<ViewFieldBuilder> allFields) {
        ViewField relatedField;
        UUID beId = filterBuilder.getBusinessEntityId();
        UUID befId = filterBuilder.getBusinessEntityFieldId();
        String beName = filterBuilder.getBusinessEntityName();
        String befName = filterBuilder.getBusinessEntityFieldName();
        Set relatedFieldBuilderSet = allFields.stream().filter(viewFieldBuilder -> befName.equals(viewFieldBuilder.getBusinessEntityFieldName())).filter(viewFieldBuilder -> beName.equals(viewFieldBuilder.getBusinessEntityName())).collect(Collectors.toSet());
        if (relatedFieldBuilderSet.isEmpty()) {
            BusinessEntityField businessEntityField = this.getBusinessEntityField(filterBuilder);
            relatedField = new ViewField();
            relatedField.setId(TimeStampUUIDGenerator.generateId());
            relatedField.setLabel(filterBuilder.getBusinessEntityFieldName());
            relatedField.setBusinessEntityId(businessEntityField.getBusinessEntityId());
            relatedField.setEntityFieldId(businessEntityField.getId());
            relatedField.setAggregationType(filterBuilder.getFieldAggregationType());
            relatedField.setHidden(true);
            outputHiddenFields.add(relatedField);
        } else {
            ViewFieldBuilder relatedFieldBuilder = (ViewFieldBuilder)relatedFieldBuilderSet.iterator().next();
            relatedField = relatedFieldBuilder.getResultViewField();
        }
        relatedField.setEnableRuntimeFilter(true);
        HashSet selection = Sets.newHashSet((Iterable)filterBuilder.getSelection());
        RuntimeFilterField heatMeterFilterField = new RuntimeFilterField();
        heatMeterFilterField.setViewFieldId(relatedField.getId());
        heatMeterFilterField.setName(filterBuilder.getBusinessEntityFieldName());
        heatMeterFilterField.setOptions((Set)selection);
        heatMeterFilterField.setSelection((Set)selection);
        heatMeterFilterField.setCondition(filterBuilder.getFilterCondition());
        outputRuntimeFilterFields.add(heatMeterFilterField);
    }

    private ViewField createDateViewField(ViewFieldBuilder viewFieldBuilder) {
        ViewField dateField = new ViewField();
        dateField.setId(viewFieldBuilder.getId() != null ? viewFieldBuilder.getId() : TimeStampUUIDGenerator.generateId());
        dateField.setLabel(viewFieldBuilder.getLabel() == null ? "date" : viewFieldBuilder.getLabel());
        dateField.setVirtualDateField(true);
        dateField.setAggregationType(viewFieldBuilder.getFieldAggregation());
        dateField.setDateGrouping(viewFieldBuilder.getDateAggregationType());
        viewFieldBuilder.setResultViewField(dateField);
        return dateField;
    }

    private ViewField createStateViewField(ViewFieldBuilder viewFieldBuilder) {
        ViewField stateField = new ViewField();
        stateField.setId(viewFieldBuilder.getId() != null ? viewFieldBuilder.getId() : TimeStampUUIDGenerator.generateId());
        stateField.setLabel(viewFieldBuilder.getLabel() == null ? "State field" : viewFieldBuilder.getLabel());
        stateField.setStateField(true);
        stateField.setAggregationType(viewFieldBuilder.getFieldAggregation());
        stateField.setCalcFunction("true;");
        stateField.setStateCondition(viewFieldBuilder.getStateCondition());
        stateField.setEntityFieldId(viewFieldBuilder.getBusinessEntityFieldId());
        viewFieldBuilder.setResultViewField(stateField);
        return stateField;
    }

    private ViewField createCalculatedViewField(ViewFieldBuilder viewFieldBuilder) {
        ViewField calculatedField = new ViewField();
        calculatedField.setId(viewFieldBuilder.getId() != null ? viewFieldBuilder.getId() : TimeStampUUIDGenerator.generateId());
        calculatedField.setLabel(viewFieldBuilder.getLabel() == null ? "Calculated field" : viewFieldBuilder.getLabel());
        calculatedField.setCalculatedField(true);
        calculatedField.setAggregationType(viewFieldBuilder.getFieldAggregation());
        calculatedField.setCalcFunction(viewFieldBuilder.getCalculatedFunction());
        calculatedField.setParsedFunction(viewFieldBuilder.getParsedFunction());
        calculatedField.setEntityFieldId(viewFieldBuilder.getBusinessEntityFieldId());
        viewFieldBuilder.setResultViewField(calculatedField);
        return calculatedField;
    }

    private ViewField createAttributeOrTelemetryViewField(ViewFieldBuilder viewFieldBuilder) {
        BusinessEntityField businessEntityField = this.getBusinessEntityField(viewFieldBuilder);
        ViewField viewField = new ViewField();
        viewField.setId(viewFieldBuilder.getId() != null ? viewFieldBuilder.getId() : TimeStampUUIDGenerator.generateId());
        viewField.setLabel(viewFieldBuilder.getLabel() == null ? viewFieldBuilder.getBusinessEntityFieldName() : viewField.getLabel());
        viewField.setBusinessEntityId(businessEntityField.getBusinessEntityId());
        viewField.setEntityFieldId(businessEntityField.getId());
        viewField.setAggregationType(viewFieldBuilder.getFieldAggregation());
        viewFieldBuilder.setResultViewField(viewField);
        return viewField;
    }

    private BusinessEntityField getBusinessEntityField(ViewFieldBuilder viewFieldBuilder) {
        if (viewFieldBuilder.getBusinessEntityFieldId() != null) {
            return this.businessEntityService.findEntityFieldById(viewFieldBuilder.getBusinessEntityFieldId());
        }
        if (viewFieldBuilder.getBusinessEntityFieldName() != null) {
            return this.businessEntityService.findEntityFieldByNameAndEntityName(viewFieldBuilder.getBusinessEntityFieldName(), viewFieldBuilder.getBusinessEntityName(), viewFieldBuilder.getTenantId());
        }
        throw new IllegalArgumentException("There is no necessary data for defining particular business entity field");
    }

    private BusinessEntityField getBusinessEntityField(RuntimeFilterBuilder runtimeFilterBuilder) {
        if (runtimeFilterBuilder.getBusinessEntityFieldId() != null) {
            return this.businessEntityService.findEntityFieldById(runtimeFilterBuilder.getBusinessEntityFieldId());
        }
        if (runtimeFilterBuilder.getBusinessEntityFieldName() != null) {
            return this.businessEntityService.findEntityFieldByNameAndEntityName(runtimeFilterBuilder.getBusinessEntityFieldName(), runtimeFilterBuilder.getBusinessEntityName(), runtimeFilterBuilder.getTenantId());
        }
        throw new IllegalArgumentException("There is no necessary data for defining particular business entity field");
    }
}

