/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.builder.view;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.sql.TimeStampUUIDGenerator;
import org.thingsboard.trendz.domain.builder.view.DatePickerRange;
import org.thingsboard.trendz.domain.builder.view.ViewConfigBuilder;
import org.thingsboard.trendz.domain.builder.view.ViewFieldBuilderFactory;
import org.thingsboard.trendz.domain.definition.view.config.CacheSettings;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfigDefinition;
import org.thingsboard.trendz.service.definition.BusinessEntityService;

@Service
public class ViewConfigBuilderFactory {
    private static final Logger log = LoggerFactory.getLogger(ViewConfigBuilderFactory.class);
    @Autowired
    private ViewFieldBuilderFactory viewFieldBuilderFactory;
    @Autowired
    private BusinessEntityService businessEntityService;

    public ViewConfig buildViewConfig(ViewConfigBuilder builder) {
        long currentTime = System.currentTimeMillis();
        ViewConfig viewConfig = new ViewConfig();
        viewConfig.setId(builder.getId() != null ? builder.getId() : TimeStampUUIDGenerator.generateId());
        viewConfig.setName(builder.getName() != null ? builder.getName() : "Generated ViewConfig " + viewConfig.getId());
        if (builder.getViewType() == null) {
            throw new IllegalArgumentException("View Config Builder must has defined View Type");
        }
        viewConfig.setViewType(builder.getViewType());
        viewConfig.setCacheSettings(new CacheSettings(builder.getCacheSettings()));
        viewConfig.setConfigDefinition(this.getDefaultViewConfigDefinition());
        viewConfig.setCreatedAt(currentTime);
        viewConfig.setUpdatedAt(currentTime);
        viewConfig.setTzName(builder.getTzName());
        viewConfig.setDatePickerConfig(this.getDatePickerConfig(builder.getStartTs(), builder.getEndTs(), builder.getDatePickerRangeBy(), builder.getDatePickerRangeByAmount()));
        viewConfig.setSettings(this.getDefaultInterfaceSettings());
        if (builder.getRowClickEntityName() != null) {
            UUID businessEntityId = this.businessEntityService.findEntityIdByName(builder.getRowClickEntityName(), builder.getTenantId());
            viewConfig.setRowClickEntityId(businessEntityId);
        }
        viewConfig.setxAxis(builder.getBeFields_xAxis().stream().map(arg_0 -> ((ViewFieldBuilderFactory)this.viewFieldBuilderFactory).processViewField(arg_0)).collect(Collectors.toList()));
        viewConfig.setyAxis(builder.getBeFields_yAxis().stream().map(arg_0 -> ((ViewFieldBuilderFactory)this.viewFieldBuilderFactory).processViewField(arg_0)).collect(Collectors.toList()));
        viewConfig.setSeries(builder.getBeFields_Series().stream().map(arg_0 -> ((ViewFieldBuilderFactory)this.viewFieldBuilderFactory).processViewField(arg_0)).collect(Collectors.toList()));
        ArrayList allFields = new ArrayList();
        allFields.addAll(builder.getBeFields_xAxis());
        allFields.addAll(builder.getBeFields_yAxis());
        allFields.addAll(builder.getBeFields_Series());
        viewConfig.setHiddenFields(new ArrayList());
        viewConfig.setRuntimeFilters(new ArrayList());
        builder.getFilters().forEach(filterBuilder -> this.viewFieldBuilderFactory.processRuntimeFilterField(viewConfig.getHiddenFields(), viewConfig.getRuntimeFilters(), filterBuilder, allFields));
        return viewConfig;
    }

    private ViewConfigDefinition getDefaultViewConfigDefinition() {
        ViewConfigDefinition viewConfigDefinition = new ViewConfigDefinition();
        viewConfigDefinition.setShowXAxis(true);
        viewConfigDefinition.setShowYAxis(true);
        viewConfigDefinition.setShowSeries(true);
        viewConfigDefinition.setxAxisLabel("X axis");
        viewConfigDefinition.setyAxisLabel("Y axis");
        viewConfigDefinition.setSeriesLabel("Series");
        return viewConfigDefinition;
    }

    private DatePickerConfig getDatePickerConfig(long startTs, long endTs, DatePickerRange datePickerRangeBy, int datePickerRangeByAmount) {
        DatePickerConfig config = new DatePickerConfig();
        config.setStartTs(startTs);
        config.setEndTs(endTs);
        config.setRangeBy(datePickerRangeBy == null ? null : datePickerRangeBy.toString());
        config.setRangeByAmount(datePickerRangeByAmount);
        config.setSelectedType(null);
        return config;
    }

    private JsonNode getDefaultInterfaceSettings() {
        String value = "{\"hideFilterInView\":false,\"hideDatePickerInView\":false,\"heatMapByOptionInView\":false,\"hideComparisonInView\":false,\"heatShowLabels\":true,\"missedGraphEntities\":[],\"barHorizontal\":false,\"barStacked\":false,\"barStachedFull\":false,\"barShowLabels\":false,\"annotations\":[],\"decimalPointMap\":{},\"paletteColorMap\":{},\"legendDisabled\":false,\"legendPosition\":\"right\",\"legendAllignment\":\"left\",\"strokeCurve\":\"smooth\",\"strokeDashed\":false,\"hideXAxisLabel\":false,\"xAxisPosition\":\"bottom\",\"tableShowTotal\":false,\"tableAutofit\":\"Fit Headers\",\"showExport\":false,\"paletteColors\":[\"#008FFB\",\"#00E396\",\"#FEB019\",\"#FF4560\",\"#775DD0\",\"#3F51B5\",\"#4CAF50\",\"#D4526E\",\"#546E7A\",\"#81D4FA\"],\"paletteColorsHeatmap\":[\"#feedde\",\"#fdbe85\",\"#fd8d3c\",\"#e6550d\",\"#a63603\"],\"bgColor\":\"transparent\",\"textColor\":\"black\",\"useSingleAxis\":false}";
        try {
            return new ObjectMapper().readTree(value);
        }
        catch (IOException e) {
            log.warn("Error during deserializing JSON interface settings of view config", (Throwable)e);
            return null;
        }
    }
}

