/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.builder.model;

import java.util.ArrayList;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.sql.TimeStampUUIDGenerator;
import org.thingsboard.trendz.domain.builder.model.DatasetConfigBuilder;
import org.thingsboard.trendz.domain.builder.view.ViewFieldBuilderFactory;
import org.thingsboard.trendz.ml.domain.DatasetConfig;

@Service
public class DatasetConfigBuilderFactory {
    private static final Logger log = LoggerFactory.getLogger(DatasetConfigBuilderFactory.class);
    @Autowired
    private ViewFieldBuilderFactory viewFieldBuilderFactory;

    public DatasetConfig buildDatasetConfig(DatasetConfigBuilder builder) {
        DatasetConfig datasetConfig = new DatasetConfig();
        datasetConfig.setId(builder.getId() != null ? builder.getId() : TimeStampUUIDGenerator.generateId());
        datasetConfig.setTenantId(builder.getTenantId());
        datasetConfig.setJwtToken(builder.getJwtToken());
        datasetConfig.setStartTs(builder.getStartTs());
        datasetConfig.setEndTs(builder.getEndTs());
        datasetConfig.setMaxPointsCount(builder.getMaxPointsCount());
        datasetConfig.setFields(builder.getBeFields().stream().map(arg_0 -> ((ViewFieldBuilderFactory)this.viewFieldBuilderFactory).processViewField(arg_0)).collect(Collectors.toList()));
        datasetConfig.setHiddenFields(new ArrayList());
        datasetConfig.setRuntimeFilters(new ArrayList());
        builder.getFilters().forEach(filterBuilder -> this.viewFieldBuilderFactory.processRuntimeFilterField(datasetConfig.getHiddenFields(), datasetConfig.getRuntimeFilters(), filterBuilder, builder.getBeFields()));
        return datasetConfig;
    }
}

