/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.builder.model;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.domain.builder.view.RuntimeFilterBuilder;
import org.thingsboard.trendz.domain.builder.view.ViewFieldBuilder;

public class DatasetConfigBuilder {
    private UUID id;
    private TenantId tenantId;
    private String jwtToken;
    private long startTs;
    private long endTs;
    private int maxPointsCount;
    private List<ViewFieldBuilder> beFields = new ArrayList();
    private List<RuntimeFilterBuilder> filters = new ArrayList();

    public DatasetConfigBuilder(UUID id, TenantId tenantId, String jwtToken) {
        this.id = id;
        this.tenantId = tenantId;
        this.jwtToken = jwtToken;
    }

    public void addField(ViewFieldBuilder viewFieldBuilder) {
        viewFieldBuilder.setTenantId(this.tenantId);
        this.beFields.add(viewFieldBuilder);
    }

    public void addFilter(RuntimeFilterBuilder filter) {
        filter.setTenantId(this.tenantId);
        this.filters.add(filter);
    }

    public UUID getId() {
        return this.id;
    }

    public TenantId getTenantId() {
        return this.tenantId;
    }

    public String getJwtToken() {
        return this.jwtToken;
    }

    public long getStartTs() {
        return this.startTs;
    }

    public long getEndTs() {
        return this.endTs;
    }

    public int getMaxPointsCount() {
        return this.maxPointsCount;
    }

    public List<ViewFieldBuilder> getBeFields() {
        return this.beFields;
    }

    public List<RuntimeFilterBuilder> getFilters() {
        return this.filters;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setJwtToken(String jwtToken) {
        this.jwtToken = jwtToken;
    }

    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    public void setEndTs(long endTs) {
        this.endTs = endTs;
    }

    public void setMaxPointsCount(int maxPointsCount) {
        this.maxPointsCount = maxPointsCount;
    }

    public void setBeFields(List<ViewFieldBuilder> beFields) {
        this.beFields = beFields;
    }

    public void setFilters(List<RuntimeFilterBuilder> filters) {
        this.filters = filters;
    }
}

