/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.sql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.PredictionType;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;

@Entity(name="view_field")
@Table(name="view_field")
public class ViewFieldDto {
    @Transient
    private static final ObjectMapper mapper = new ObjectMapper();
    @Id
    private UUID id;
    private UUID entityFieldId;
    private UUID businessEntityId;
    @Column(name="view_config_id")
    private UUID viewConfigId;
    private String aggregationType;
    @Column(name="field_order")
    private int order;
    private String fieldDefinition;
    @Column(name="field_label")
    private String label;
    private String unit;
    private boolean scaleValue;
    private boolean hidden;
    private boolean skipRender;
    private boolean missedRelationField;
    private boolean enableRuntimeFilter;
    private boolean calculatedField;
    private boolean batchCalculation;
    private String calcFunction;
    private String parsedFunction;
    private boolean stateField;
    private String stateCondition;
    private boolean forStateCondition;
    private String parsedCondition;
    private String conditionFieldIds;
    private boolean predictionEnabled;
    private int predictionRangeSec;
    private String predictionMethod;
    private boolean includeHistoricalData;
    private String localTimeRange;
    private boolean virtualDateField;
    private String dateGrouping;
    private boolean separateViewGroup;
    private boolean separateAxis;
    private String seriaType;
    private String colorConfig;

    public ViewField toData() {
        ViewField viewField = new ViewField();
        viewField.setId(this.id);
        viewField.setEntityFieldId(this.entityFieldId);
        viewField.setBusinessEntityId(this.businessEntityId);
        viewField.setAggregationType(this.aggregationType != null ? FieldAggregation.valueOf((String)this.aggregationType) : null);
        viewField.setLabel(this.label);
        viewField.setUnit(this.unit);
        viewField.setScaleValue(this.scaleValue);
        viewField.setHidden(this.hidden);
        viewField.setSkipRender(this.skipRender);
        viewField.setMissedRelationField(this.missedRelationField);
        viewField.setEnableRuntimeFilter(this.enableRuntimeFilter);
        viewField.setCalculatedField(this.calculatedField);
        viewField.setBatchCalculation(this.batchCalculation);
        viewField.setCalcFunction(this.calcFunction);
        viewField.setParsedFunction(this.parsedFunction);
        viewField.setStateField(this.stateField);
        viewField.setStateCondition(this.stateCondition);
        viewField.setForStateCondition(this.forStateCondition);
        viewField.setParsedCondition(this.parsedCondition);
        viewField.setPredictionEnabled(this.predictionEnabled);
        viewField.setPredictionRangeSec(this.predictionRangeSec);
        viewField.setPredictionMethod(this.predictionMethod != null ? PredictionType.valueOf((String)this.predictionMethod) : null);
        viewField.setIncludeHistoricalData(this.includeHistoricalData);
        viewField.setVirtualDateField(this.virtualDateField);
        viewField.setDateGrouping(this.dateGrouping != null ? DateAggregationType.valueOf((String)this.dateGrouping) : null);
        viewField.setSeparateViewGroup(this.separateViewGroup);
        viewField.setSeparateAxis(this.separateAxis);
        viewField.setSeriaType(this.seriaType);
        try {
            viewField.setColorConfig(this.colorConfig != null ? mapper.readTree(this.colorConfig) : null);
            viewField.setLocalTimeRange(this.localTimeRange != null && !"null".equals(this.localTimeRange) ? (DatePickerConfig)mapper.readValue(this.localTimeRange, DatePickerConfig.class) : null);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not deserialize View Field color config or localTime from DB: " + this.id + "  json: " + this.colorConfig, e);
        }
        return viewField;
    }

    public static ViewFieldDto from(String fieldDefinition, ViewField entity, UUID viewConfigId) {
        ViewFieldDto dto = new ViewFieldDto();
        dto.setId(entity.getId());
        dto.setViewConfigId(viewConfigId);
        dto.setFieldDefinition(fieldDefinition);
        dto.setEntityFieldId(entity.getEntityFieldId());
        dto.setBusinessEntityId(entity.getBusinessEntityId());
        dto.setAggregationType(entity.getAggregationType() != null ? entity.getAggregationType().name() : null);
        dto.setLabel(entity.getLabel());
        dto.setUnit(entity.getUnit());
        dto.setScaleValue(entity.isScaleValue());
        dto.setHidden(entity.isHidden());
        dto.setSkipRender(entity.isSkipRender());
        dto.setMissedRelationField(entity.isMissedRelationField());
        dto.setEnableRuntimeFilter(entity.isEnableRuntimeFilter());
        dto.setCalculatedField(entity.isCalculatedField());
        dto.setBatchCalculation(entity.isBatchCalculation());
        dto.setCalcFunction(entity.getCalcFunction());
        dto.setParsedFunction(entity.getParsedFunction());
        dto.setStateField(entity.isStateField());
        dto.setStateCondition(entity.getStateCondition());
        dto.setForStateCondition(entity.isForStateCondition());
        dto.setParsedCondition(entity.getParsedCondition());
        dto.setPredictionEnabled(entity.isPredictionEnabled());
        dto.setPredictionRangeSec(entity.getPredictionRangeSec());
        if (entity.getPredictionMethod() != null) {
            dto.setPredictionMethod(entity.getPredictionMethod().name());
        }
        dto.setIncludeHistoricalData(entity.isIncludeHistoricalData());
        dto.setVirtualDateField(entity.isVirtualDateField());
        dto.setDateGrouping(entity.getDateGrouping() != null ? entity.getDateGrouping().name() : null);
        dto.setSeparateViewGroup(entity.isSeparateViewGroup());
        dto.setSeparateAxis(entity.isSeparateAxis());
        dto.setSeriaType(entity.getSeriaType());
        if (entity.getColorConfig() != null) {
            dto.setColorConfig(entity.getColorConfig().toString());
        }
        try {
            dto.setConditionFieldIds(mapper.writeValueAsString((Object)entity.getConditionFieldIds()));
            dto.setLocalTimeRange(mapper.writeValueAsString((Object)entity.getLocalTimeRange()));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Could not serialize View Config to DTO: " + entity, e);
        }
        return dto;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getEntityFieldId() {
        return this.entityFieldId;
    }

    public UUID getBusinessEntityId() {
        return this.businessEntityId;
    }

    public UUID getViewConfigId() {
        return this.viewConfigId;
    }

    public String getAggregationType() {
        return this.aggregationType;
    }

    public int getOrder() {
        return this.order;
    }

    public String getFieldDefinition() {
        return this.fieldDefinition;
    }

    public String getLabel() {
        return this.label;
    }

    public String getUnit() {
        return this.unit;
    }

    public boolean isScaleValue() {
        return this.scaleValue;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isSkipRender() {
        return this.skipRender;
    }

    public boolean isMissedRelationField() {
        return this.missedRelationField;
    }

    public boolean isEnableRuntimeFilter() {
        return this.enableRuntimeFilter;
    }

    public boolean isCalculatedField() {
        return this.calculatedField;
    }

    public boolean isBatchCalculation() {
        return this.batchCalculation;
    }

    public String getCalcFunction() {
        return this.calcFunction;
    }

    public String getParsedFunction() {
        return this.parsedFunction;
    }

    public boolean isStateField() {
        return this.stateField;
    }

    public String getStateCondition() {
        return this.stateCondition;
    }

    public boolean isForStateCondition() {
        return this.forStateCondition;
    }

    public String getParsedCondition() {
        return this.parsedCondition;
    }

    public String getConditionFieldIds() {
        return this.conditionFieldIds;
    }

    public boolean isPredictionEnabled() {
        return this.predictionEnabled;
    }

    public int getPredictionRangeSec() {
        return this.predictionRangeSec;
    }

    public String getPredictionMethod() {
        return this.predictionMethod;
    }

    public boolean isIncludeHistoricalData() {
        return this.includeHistoricalData;
    }

    public String getLocalTimeRange() {
        return this.localTimeRange;
    }

    public boolean isVirtualDateField() {
        return this.virtualDateField;
    }

    public String getDateGrouping() {
        return this.dateGrouping;
    }

    public boolean isSeparateViewGroup() {
        return this.separateViewGroup;
    }

    public boolean isSeparateAxis() {
        return this.separateAxis;
    }

    public String getSeriaType() {
        return this.seriaType;
    }

    public String getColorConfig() {
        return this.colorConfig;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setEntityFieldId(UUID entityFieldId) {
        this.entityFieldId = entityFieldId;
    }

    public void setBusinessEntityId(UUID businessEntityId) {
        this.businessEntityId = businessEntityId;
    }

    public void setViewConfigId(UUID viewConfigId) {
        this.viewConfigId = viewConfigId;
    }

    public void setAggregationType(String aggregationType) {
        this.aggregationType = aggregationType;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setFieldDefinition(String fieldDefinition) {
        this.fieldDefinition = fieldDefinition;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setScaleValue(boolean scaleValue) {
        this.scaleValue = scaleValue;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setSkipRender(boolean skipRender) {
        this.skipRender = skipRender;
    }

    public void setMissedRelationField(boolean missedRelationField) {
        this.missedRelationField = missedRelationField;
    }

    public void setEnableRuntimeFilter(boolean enableRuntimeFilter) {
        this.enableRuntimeFilter = enableRuntimeFilter;
    }

    public void setCalculatedField(boolean calculatedField) {
        this.calculatedField = calculatedField;
    }

    public void setBatchCalculation(boolean batchCalculation) {
        this.batchCalculation = batchCalculation;
    }

    public void setCalcFunction(String calcFunction) {
        this.calcFunction = calcFunction;
    }

    public void setParsedFunction(String parsedFunction) {
        this.parsedFunction = parsedFunction;
    }

    public void setStateField(boolean stateField) {
        this.stateField = stateField;
    }

    public void setStateCondition(String stateCondition) {
        this.stateCondition = stateCondition;
    }

    public void setForStateCondition(boolean forStateCondition) {
        this.forStateCondition = forStateCondition;
    }

    public void setParsedCondition(String parsedCondition) {
        this.parsedCondition = parsedCondition;
    }

    public void setConditionFieldIds(String conditionFieldIds) {
        this.conditionFieldIds = conditionFieldIds;
    }

    public void setPredictionEnabled(boolean predictionEnabled) {
        this.predictionEnabled = predictionEnabled;
    }

    public void setPredictionRangeSec(int predictionRangeSec) {
        this.predictionRangeSec = predictionRangeSec;
    }

    public void setPredictionMethod(String predictionMethod) {
        this.predictionMethod = predictionMethod;
    }

    public void setIncludeHistoricalData(boolean includeHistoricalData) {
        this.includeHistoricalData = includeHistoricalData;
    }

    public void setLocalTimeRange(String localTimeRange) {
        this.localTimeRange = localTimeRange;
    }

    public void setVirtualDateField(boolean virtualDateField) {
        this.virtualDateField = virtualDateField;
    }

    public void setDateGrouping(String dateGrouping) {
        this.dateGrouping = dateGrouping;
    }

    public void setSeparateViewGroup(boolean separateViewGroup) {
        this.separateViewGroup = separateViewGroup;
    }

    public void setSeparateAxis(boolean separateAxis) {
        this.separateAxis = separateAxis;
    }

    public void setSeriaType(String seriaType) {
        this.seriaType = seriaType;
    }

    public void setColorConfig(String colorConfig) {
        this.colorConfig = colorConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ViewFieldDto)) {
            return false;
        }
        ViewFieldDto other = (ViewFieldDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$entityFieldId = this.getEntityFieldId();
        UUID other$entityFieldId = other.getEntityFieldId();
        if (this$entityFieldId == null ? other$entityFieldId != null : !((Object)this$entityFieldId).equals(other$entityFieldId)) {
            return false;
        }
        UUID this$businessEntityId = this.getBusinessEntityId();
        UUID other$businessEntityId = other.getBusinessEntityId();
        if (this$businessEntityId == null ? other$businessEntityId != null : !((Object)this$businessEntityId).equals(other$businessEntityId)) {
            return false;
        }
        UUID this$viewConfigId = this.getViewConfigId();
        UUID other$viewConfigId = other.getViewConfigId();
        if (this$viewConfigId == null ? other$viewConfigId != null : !((Object)this$viewConfigId).equals(other$viewConfigId)) {
            return false;
        }
        String this$aggregationType = this.getAggregationType();
        String other$aggregationType = other.getAggregationType();
        if (this$aggregationType == null ? other$aggregationType != null : !this$aggregationType.equals(other$aggregationType)) {
            return false;
        }
        if (this.getOrder() != other.getOrder()) {
            return false;
        }
        String this$fieldDefinition = this.getFieldDefinition();
        String other$fieldDefinition = other.getFieldDefinition();
        if (this$fieldDefinition == null ? other$fieldDefinition != null : !this$fieldDefinition.equals(other$fieldDefinition)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        if (this.isScaleValue() != other.isScaleValue()) {
            return false;
        }
        if (this.isHidden() != other.isHidden()) {
            return false;
        }
        if (this.isSkipRender() != other.isSkipRender()) {
            return false;
        }
        if (this.isMissedRelationField() != other.isMissedRelationField()) {
            return false;
        }
        if (this.isEnableRuntimeFilter() != other.isEnableRuntimeFilter()) {
            return false;
        }
        if (this.isCalculatedField() != other.isCalculatedField()) {
            return false;
        }
        if (this.isBatchCalculation() != other.isBatchCalculation()) {
            return false;
        }
        String this$calcFunction = this.getCalcFunction();
        String other$calcFunction = other.getCalcFunction();
        if (this$calcFunction == null ? other$calcFunction != null : !this$calcFunction.equals(other$calcFunction)) {
            return false;
        }
        String this$parsedFunction = this.getParsedFunction();
        String other$parsedFunction = other.getParsedFunction();
        if (this$parsedFunction == null ? other$parsedFunction != null : !this$parsedFunction.equals(other$parsedFunction)) {
            return false;
        }
        if (this.isStateField() != other.isStateField()) {
            return false;
        }
        String this$stateCondition = this.getStateCondition();
        String other$stateCondition = other.getStateCondition();
        if (this$stateCondition == null ? other$stateCondition != null : !this$stateCondition.equals(other$stateCondition)) {
            return false;
        }
        if (this.isForStateCondition() != other.isForStateCondition()) {
            return false;
        }
        String this$parsedCondition = this.getParsedCondition();
        String other$parsedCondition = other.getParsedCondition();
        if (this$parsedCondition == null ? other$parsedCondition != null : !this$parsedCondition.equals(other$parsedCondition)) {
            return false;
        }
        String this$conditionFieldIds = this.getConditionFieldIds();
        String other$conditionFieldIds = other.getConditionFieldIds();
        if (this$conditionFieldIds == null ? other$conditionFieldIds != null : !this$conditionFieldIds.equals(other$conditionFieldIds)) {
            return false;
        }
        if (this.isPredictionEnabled() != other.isPredictionEnabled()) {
            return false;
        }
        if (this.getPredictionRangeSec() != other.getPredictionRangeSec()) {
            return false;
        }
        String this$predictionMethod = this.getPredictionMethod();
        String other$predictionMethod = other.getPredictionMethod();
        if (this$predictionMethod == null ? other$predictionMethod != null : !this$predictionMethod.equals(other$predictionMethod)) {
            return false;
        }
        if (this.isIncludeHistoricalData() != other.isIncludeHistoricalData()) {
            return false;
        }
        String this$localTimeRange = this.getLocalTimeRange();
        String other$localTimeRange = other.getLocalTimeRange();
        if (this$localTimeRange == null ? other$localTimeRange != null : !this$localTimeRange.equals(other$localTimeRange)) {
            return false;
        }
        if (this.isVirtualDateField() != other.isVirtualDateField()) {
            return false;
        }
        String this$dateGrouping = this.getDateGrouping();
        String other$dateGrouping = other.getDateGrouping();
        if (this$dateGrouping == null ? other$dateGrouping != null : !this$dateGrouping.equals(other$dateGrouping)) {
            return false;
        }
        if (this.isSeparateViewGroup() != other.isSeparateViewGroup()) {
            return false;
        }
        if (this.isSeparateAxis() != other.isSeparateAxis()) {
            return false;
        }
        String this$seriaType = this.getSeriaType();
        String other$seriaType = other.getSeriaType();
        if (this$seriaType == null ? other$seriaType != null : !this$seriaType.equals(other$seriaType)) {
            return false;
        }
        String this$colorConfig = this.getColorConfig();
        String other$colorConfig = other.getColorConfig();
        return !(this$colorConfig == null ? other$colorConfig != null : !this$colorConfig.equals(other$colorConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ViewFieldDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $entityFieldId = this.getEntityFieldId();
        result = result * 59 + ($entityFieldId == null ? 43 : ((Object)$entityFieldId).hashCode());
        UUID $businessEntityId = this.getBusinessEntityId();
        result = result * 59 + ($businessEntityId == null ? 43 : ((Object)$businessEntityId).hashCode());
        UUID $viewConfigId = this.getViewConfigId();
        result = result * 59 + ($viewConfigId == null ? 43 : ((Object)$viewConfigId).hashCode());
        String $aggregationType = this.getAggregationType();
        result = result * 59 + ($aggregationType == null ? 43 : $aggregationType.hashCode());
        result = result * 59 + this.getOrder();
        String $fieldDefinition = this.getFieldDefinition();
        result = result * 59 + ($fieldDefinition == null ? 43 : $fieldDefinition.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        result = result * 59 + (this.isScaleValue() ? 79 : 97);
        result = result * 59 + (this.isHidden() ? 79 : 97);
        result = result * 59 + (this.isSkipRender() ? 79 : 97);
        result = result * 59 + (this.isMissedRelationField() ? 79 : 97);
        result = result * 59 + (this.isEnableRuntimeFilter() ? 79 : 97);
        result = result * 59 + (this.isCalculatedField() ? 79 : 97);
        result = result * 59 + (this.isBatchCalculation() ? 79 : 97);
        String $calcFunction = this.getCalcFunction();
        result = result * 59 + ($calcFunction == null ? 43 : $calcFunction.hashCode());
        String $parsedFunction = this.getParsedFunction();
        result = result * 59 + ($parsedFunction == null ? 43 : $parsedFunction.hashCode());
        result = result * 59 + (this.isStateField() ? 79 : 97);
        String $stateCondition = this.getStateCondition();
        result = result * 59 + ($stateCondition == null ? 43 : $stateCondition.hashCode());
        result = result * 59 + (this.isForStateCondition() ? 79 : 97);
        String $parsedCondition = this.getParsedCondition();
        result = result * 59 + ($parsedCondition == null ? 43 : $parsedCondition.hashCode());
        String $conditionFieldIds = this.getConditionFieldIds();
        result = result * 59 + ($conditionFieldIds == null ? 43 : $conditionFieldIds.hashCode());
        result = result * 59 + (this.isPredictionEnabled() ? 79 : 97);
        result = result * 59 + this.getPredictionRangeSec();
        String $predictionMethod = this.getPredictionMethod();
        result = result * 59 + ($predictionMethod == null ? 43 : $predictionMethod.hashCode());
        result = result * 59 + (this.isIncludeHistoricalData() ? 79 : 97);
        String $localTimeRange = this.getLocalTimeRange();
        result = result * 59 + ($localTimeRange == null ? 43 : $localTimeRange.hashCode());
        result = result * 59 + (this.isVirtualDateField() ? 79 : 97);
        String $dateGrouping = this.getDateGrouping();
        result = result * 59 + ($dateGrouping == null ? 43 : $dateGrouping.hashCode());
        result = result * 59 + (this.isSeparateViewGroup() ? 79 : 97);
        result = result * 59 + (this.isSeparateAxis() ? 79 : 97);
        String $seriaType = this.getSeriaType();
        result = result * 59 + ($seriaType == null ? 43 : $seriaType.hashCode());
        String $colorConfig = this.getColorConfig();
        result = result * 59 + ($colorConfig == null ? 43 : $colorConfig.hashCode());
        return result;
    }

    public String toString() {
        return "ViewFieldDto(id=" + this.getId() + ", entityFieldId=" + this.getEntityFieldId() + ", businessEntityId=" + this.getBusinessEntityId() + ", viewConfigId=" + this.getViewConfigId() + ", aggregationType=" + this.getAggregationType() + ", order=" + this.getOrder() + ", fieldDefinition=" + this.getFieldDefinition() + ", label=" + this.getLabel() + ", unit=" + this.getUnit() + ", scaleValue=" + this.isScaleValue() + ", hidden=" + this.isHidden() + ", skipRender=" + this.isSkipRender() + ", missedRelationField=" + this.isMissedRelationField() + ", enableRuntimeFilter=" + this.isEnableRuntimeFilter() + ", calculatedField=" + this.isCalculatedField() + ", batchCalculation=" + this.isBatchCalculation() + ", calcFunction=" + this.getCalcFunction() + ", parsedFunction=" + this.getParsedFunction() + ", stateField=" + this.isStateField() + ", stateCondition=" + this.getStateCondition() + ", forStateCondition=" + this.isForStateCondition() + ", parsedCondition=" + this.getParsedCondition() + ", conditionFieldIds=" + this.getConditionFieldIds() + ", predictionEnabled=" + this.isPredictionEnabled() + ", predictionRangeSec=" + this.getPredictionRangeSec() + ", predictionMethod=" + this.getPredictionMethod() + ", includeHistoricalData=" + this.isIncludeHistoricalData() + ", localTimeRange=" + this.getLocalTimeRange() + ", virtualDateField=" + this.isVirtualDateField() + ", dateGrouping=" + this.getDateGrouping() + ", separateViewGroup=" + this.isSeparateViewGroup() + ", separateAxis=" + this.isSeparateAxis() + ", seriaType=" + this.getSeriaType() + ", colorConfig=" + this.getColorConfig() + ")";
    }
}

