/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.sql;

import com.clearspring.analytics.util.Lists;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.dao.sql.ViewFieldDto;
import org.thingsboard.trendz.domain.definition.view.config.CacheSettings;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfigDefinition;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.definition.view.config.ViewType;

@Entity
@Table(name="view_config")
public class ViewConfigDto {
    @Transient
    private static final ObjectMapper mapper = new ObjectMapper();
    @Id
    private UUID id;
    @Column(name="tenant_id")
    private UUID tenantId;
    private String name;
    private String viewType;
    private String configDefinition;
    private UUID rootEntityId;
    private UUID rowClickEntityId;
    private long createdAt;
    private long updatedAt;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="view_config_id")
    private List<ViewFieldDto> allFields;
    private String runtimeFilters;
    @Column(length=100000)
    private String settings;
    @Column(name="enable_report_cache")
    private Boolean useReportCache;
    @Column(name="enable_persisted_cache")
    private Boolean usePersistedCacheTelemetry;
    @Enumerated(value=EnumType.STRING)
    @Column(name="cache_time_unit")
    private DateAggregationType cachingDateAggregation;
    @Column(name="auto_refresh_cache")
    private Boolean autoRefreshCache;
    @Column(name="task_id")
    private UUID taskId;
    @Column(name="refresh_frequency_time_unit")
    private String refreshFrequencyTimeUnit;
    @Column(name="refresh_frequency_time_unit_count")
    private Integer refreshFrequencyTimeUnitCount;
    @Column(length=100000)
    private String datePickerConfig;
    private String tzName;

    public ViewConfig toData() {
        this.allFields.sort(Comparator.comparingInt(ViewFieldDto::getOrder));
        ViewConfig viewConfig = new ViewConfig();
        viewConfig.setId(this.id);
        viewConfig.setName(this.name);
        viewConfig.setViewType(ViewType.valueOf((String)this.viewType));
        viewConfig.setRootEntityId(this.rootEntityId);
        viewConfig.setRowClickEntityId(this.rowClickEntityId);
        viewConfig.setCreatedAt(this.createdAt);
        viewConfig.setUpdatedAt(this.updatedAt);
        viewConfig.setxAxis(this.allFields.stream().filter(viewFieldDto -> viewFieldDto.getFieldDefinition().equalsIgnoreCase("xAxis")).map(ViewFieldDto::toData).collect(Collectors.toList()));
        viewConfig.setyAxis(this.allFields.stream().filter(viewFieldDto -> viewFieldDto.getFieldDefinition().equalsIgnoreCase("yAxis")).map(ViewFieldDto::toData).collect(Collectors.toList()));
        viewConfig.setSeries(this.allFields.stream().filter(viewFieldDto -> viewFieldDto.getFieldDefinition().equalsIgnoreCase("series")).map(ViewFieldDto::toData).collect(Collectors.toList()));
        viewConfig.setHiddenFields(this.allFields.stream().filter(viewFieldDto -> viewFieldDto.getFieldDefinition().equalsIgnoreCase("hidden")).map(ViewFieldDto::toData).collect(Collectors.toList()));
        viewConfig.setTzName(this.tzName);
        viewConfig.setCacheSettings(CacheSettings.builder().useReportCache(Boolean.valueOf(BooleanUtils.toBoolean((Boolean)this.useReportCache))).usePersistedCacheTelemetry(BooleanUtils.toBoolean((Boolean)this.usePersistedCacheTelemetry)).cachingDateAggregation(this.cachingDateAggregation).autoRefreshCache(BooleanUtils.toBoolean((Boolean)this.autoRefreshCache)).taskId(this.taskId).refreshFrequencyTimeUnit(this.refreshFrequencyTimeUnit).refreshFrequencyTimeUnitCount(((Integer)ObjectUtils.defaultIfNull((Object)this.refreshFrequencyTimeUnitCount, (Object)1)).intValue()).build());
        try {
            viewConfig.setConfigDefinition(this.configDefinition != null ? (ViewConfigDefinition)mapper.readValue(this.configDefinition, ViewConfigDefinition.class) : null);
            viewConfig.setRuntimeFilters(this.runtimeFilters != null ? (List)mapper.readValue(this.runtimeFilters, (TypeReference)new /* Unavailable Anonymous Inner Class!! */) : null);
            viewConfig.setSettings(mapper.readTree(this.settings));
            viewConfig.setDatePickerConfig((DatePickerConfig)mapper.readValue(this.datePickerConfig, DatePickerConfig.class));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException("Could not deserialize View Config from DB: " + this.id);
        }
        return viewConfig;
    }

    public static ViewConfigDto from(TenantId tenantId, ViewConfig entity) {
        ViewFieldDto fieldDto;
        int i;
        ViewConfigDto dto = new ViewConfigDto();
        dto.setId(entity.getId());
        dto.setTenantId(tenantId.getId());
        dto.setName(entity.getName());
        dto.setViewType(entity.getViewType() != null ? entity.getViewType().name() : null);
        dto.setRootEntityId(entity.getRootEntityId());
        dto.setRowClickEntityId(entity.getRowClickEntityId());
        dto.setCreatedAt(entity.getCreatedAt());
        dto.setUpdatedAt(entity.getUpdatedAt());
        List allFieldDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)entity.getxAxis())) {
            for (i = 0; i < entity.getxAxis().size(); ++i) {
                fieldDto = ViewFieldDto.from((String)"xAxis", (ViewField)((ViewField)entity.getxAxis().get(i)), (UUID)entity.getId());
                fieldDto.setOrder(i);
                allFieldDtos.add(fieldDto);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)entity.getyAxis())) {
            for (i = 0; i < entity.getyAxis().size(); ++i) {
                fieldDto = ViewFieldDto.from((String)"yAxis", (ViewField)((ViewField)entity.getyAxis().get(i)), (UUID)entity.getId());
                fieldDto.setOrder(i);
                allFieldDtos.add(fieldDto);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)entity.getSeries())) {
            for (i = 0; i < entity.getSeries().size(); ++i) {
                fieldDto = ViewFieldDto.from((String)"series", (ViewField)((ViewField)entity.getSeries().get(i)), (UUID)entity.getId());
                fieldDto.setOrder(i);
                allFieldDtos.add(fieldDto);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)entity.getHiddenFields())) {
            for (i = 0; i < entity.getHiddenFields().size(); ++i) {
                fieldDto = ViewFieldDto.from((String)"hidden", (ViewField)((ViewField)entity.getHiddenFields().get(i)), (UUID)entity.getId());
                fieldDto.setOrder(i);
                allFieldDtos.add(fieldDto);
            }
        }
        dto.setAllFields(allFieldDtos);
        dto.setTzName(entity.getTzName());
        CacheSettings cacheSettings = entity.getCacheSettings();
        if (cacheSettings != null) {
            dto.setUseReportCache(cacheSettings.getUseReportCache());
            dto.setUsePersistedCacheTelemetry(Boolean.valueOf(cacheSettings.isUsePersistedCacheTelemetry()));
            dto.setCachingDateAggregation(cacheSettings.getCachingDateAggregation());
            dto.setAutoRefreshCache(Boolean.valueOf(cacheSettings.isAutoRefreshCache()));
            dto.setTaskId(cacheSettings.getTaskId());
            dto.setRefreshFrequencyTimeUnit(cacheSettings.getRefreshFrequencyTimeUnit());
            dto.setRefreshFrequencyTimeUnitCount(Integer.valueOf(cacheSettings.getRefreshFrequencyTimeUnitCount()));
        }
        try {
            dto.setConfigDefinition(entity.getConfigDefinition() != null ? mapper.writeValueAsString((Object)entity.getConfigDefinition()) : null);
            dto.setRuntimeFilters(entity.getRuntimeFilters() != null ? mapper.writeValueAsString((Object)entity.getRuntimeFilters()) : null);
            dto.setSettings(entity.getSettings() != null ? entity.getSettings().toString() : null);
            dto.setDatePickerConfig(entity.getDatePickerConfig() != null ? mapper.writeValueAsString((Object)entity.getDatePickerConfig()) : null);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Could not serialize View Config to DTO: " + entity);
        }
        return dto;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public String getName() {
        return this.name;
    }

    public String getViewType() {
        return this.viewType;
    }

    public String getConfigDefinition() {
        return this.configDefinition;
    }

    public UUID getRootEntityId() {
        return this.rootEntityId;
    }

    public UUID getRowClickEntityId() {
        return this.rowClickEntityId;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public List<ViewFieldDto> getAllFields() {
        return this.allFields;
    }

    public String getRuntimeFilters() {
        return this.runtimeFilters;
    }

    public String getSettings() {
        return this.settings;
    }

    public Boolean getUseReportCache() {
        return this.useReportCache;
    }

    public Boolean getUsePersistedCacheTelemetry() {
        return this.usePersistedCacheTelemetry;
    }

    public DateAggregationType getCachingDateAggregation() {
        return this.cachingDateAggregation;
    }

    public Boolean getAutoRefreshCache() {
        return this.autoRefreshCache;
    }

    public UUID getTaskId() {
        return this.taskId;
    }

    public String getRefreshFrequencyTimeUnit() {
        return this.refreshFrequencyTimeUnit;
    }

    public Integer getRefreshFrequencyTimeUnitCount() {
        return this.refreshFrequencyTimeUnitCount;
    }

    public String getDatePickerConfig() {
        return this.datePickerConfig;
    }

    public String getTzName() {
        return this.tzName;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setViewType(String viewType) {
        this.viewType = viewType;
    }

    public void setConfigDefinition(String configDefinition) {
        this.configDefinition = configDefinition;
    }

    public void setRootEntityId(UUID rootEntityId) {
        this.rootEntityId = rootEntityId;
    }

    public void setRowClickEntityId(UUID rowClickEntityId) {
        this.rowClickEntityId = rowClickEntityId;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public void setUpdatedAt(long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setAllFields(List<ViewFieldDto> allFields) {
        this.allFields = allFields;
    }

    public void setRuntimeFilters(String runtimeFilters) {
        this.runtimeFilters = runtimeFilters;
    }

    public void setSettings(String settings) {
        this.settings = settings;
    }

    public void setUseReportCache(Boolean useReportCache) {
        this.useReportCache = useReportCache;
    }

    public void setUsePersistedCacheTelemetry(Boolean usePersistedCacheTelemetry) {
        this.usePersistedCacheTelemetry = usePersistedCacheTelemetry;
    }

    public void setCachingDateAggregation(DateAggregationType cachingDateAggregation) {
        this.cachingDateAggregation = cachingDateAggregation;
    }

    public void setAutoRefreshCache(Boolean autoRefreshCache) {
        this.autoRefreshCache = autoRefreshCache;
    }

    public void setTaskId(UUID taskId) {
        this.taskId = taskId;
    }

    public void setRefreshFrequencyTimeUnit(String refreshFrequencyTimeUnit) {
        this.refreshFrequencyTimeUnit = refreshFrequencyTimeUnit;
    }

    public void setRefreshFrequencyTimeUnitCount(Integer refreshFrequencyTimeUnitCount) {
        this.refreshFrequencyTimeUnitCount = refreshFrequencyTimeUnitCount;
    }

    public void setDatePickerConfig(String datePickerConfig) {
        this.datePickerConfig = datePickerConfig;
    }

    public void setTzName(String tzName) {
        this.tzName = tzName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ViewConfigDto)) {
            return false;
        }
        ViewConfigDto other = (ViewConfigDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$viewType = this.getViewType();
        String other$viewType = other.getViewType();
        if (this$viewType == null ? other$viewType != null : !this$viewType.equals(other$viewType)) {
            return false;
        }
        String this$configDefinition = this.getConfigDefinition();
        String other$configDefinition = other.getConfigDefinition();
        if (this$configDefinition == null ? other$configDefinition != null : !this$configDefinition.equals(other$configDefinition)) {
            return false;
        }
        UUID this$rootEntityId = this.getRootEntityId();
        UUID other$rootEntityId = other.getRootEntityId();
        if (this$rootEntityId == null ? other$rootEntityId != null : !((Object)this$rootEntityId).equals(other$rootEntityId)) {
            return false;
        }
        UUID this$rowClickEntityId = this.getRowClickEntityId();
        UUID other$rowClickEntityId = other.getRowClickEntityId();
        if (this$rowClickEntityId == null ? other$rowClickEntityId != null : !((Object)this$rowClickEntityId).equals(other$rowClickEntityId)) {
            return false;
        }
        if (this.getCreatedAt() != other.getCreatedAt()) {
            return false;
        }
        if (this.getUpdatedAt() != other.getUpdatedAt()) {
            return false;
        }
        List this$allFields = this.getAllFields();
        List other$allFields = other.getAllFields();
        if (this$allFields == null ? other$allFields != null : !((Object)this$allFields).equals(other$allFields)) {
            return false;
        }
        String this$runtimeFilters = this.getRuntimeFilters();
        String other$runtimeFilters = other.getRuntimeFilters();
        if (this$runtimeFilters == null ? other$runtimeFilters != null : !this$runtimeFilters.equals(other$runtimeFilters)) {
            return false;
        }
        String this$settings = this.getSettings();
        String other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !this$settings.equals(other$settings)) {
            return false;
        }
        Boolean this$useReportCache = this.getUseReportCache();
        Boolean other$useReportCache = other.getUseReportCache();
        if (this$useReportCache == null ? other$useReportCache != null : !((Object)this$useReportCache).equals(other$useReportCache)) {
            return false;
        }
        Boolean this$usePersistedCacheTelemetry = this.getUsePersistedCacheTelemetry();
        Boolean other$usePersistedCacheTelemetry = other.getUsePersistedCacheTelemetry();
        if (this$usePersistedCacheTelemetry == null ? other$usePersistedCacheTelemetry != null : !((Object)this$usePersistedCacheTelemetry).equals(other$usePersistedCacheTelemetry)) {
            return false;
        }
        DateAggregationType this$cachingDateAggregation = this.getCachingDateAggregation();
        DateAggregationType other$cachingDateAggregation = other.getCachingDateAggregation();
        if (this$cachingDateAggregation == null ? other$cachingDateAggregation != null : !this$cachingDateAggregation.equals(other$cachingDateAggregation)) {
            return false;
        }
        Boolean this$autoRefreshCache = this.getAutoRefreshCache();
        Boolean other$autoRefreshCache = other.getAutoRefreshCache();
        if (this$autoRefreshCache == null ? other$autoRefreshCache != null : !((Object)this$autoRefreshCache).equals(other$autoRefreshCache)) {
            return false;
        }
        UUID this$taskId = this.getTaskId();
        UUID other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !((Object)this$taskId).equals(other$taskId)) {
            return false;
        }
        String this$refreshFrequencyTimeUnit = this.getRefreshFrequencyTimeUnit();
        String other$refreshFrequencyTimeUnit = other.getRefreshFrequencyTimeUnit();
        if (this$refreshFrequencyTimeUnit == null ? other$refreshFrequencyTimeUnit != null : !this$refreshFrequencyTimeUnit.equals(other$refreshFrequencyTimeUnit)) {
            return false;
        }
        Integer this$refreshFrequencyTimeUnitCount = this.getRefreshFrequencyTimeUnitCount();
        Integer other$refreshFrequencyTimeUnitCount = other.getRefreshFrequencyTimeUnitCount();
        if (this$refreshFrequencyTimeUnitCount == null ? other$refreshFrequencyTimeUnitCount != null : !((Object)this$refreshFrequencyTimeUnitCount).equals(other$refreshFrequencyTimeUnitCount)) {
            return false;
        }
        String this$datePickerConfig = this.getDatePickerConfig();
        String other$datePickerConfig = other.getDatePickerConfig();
        if (this$datePickerConfig == null ? other$datePickerConfig != null : !this$datePickerConfig.equals(other$datePickerConfig)) {
            return false;
        }
        String this$tzName = this.getTzName();
        String other$tzName = other.getTzName();
        return !(this$tzName == null ? other$tzName != null : !this$tzName.equals(other$tzName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ViewConfigDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $viewType = this.getViewType();
        result = result * 59 + ($viewType == null ? 43 : $viewType.hashCode());
        String $configDefinition = this.getConfigDefinition();
        result = result * 59 + ($configDefinition == null ? 43 : $configDefinition.hashCode());
        UUID $rootEntityId = this.getRootEntityId();
        result = result * 59 + ($rootEntityId == null ? 43 : ((Object)$rootEntityId).hashCode());
        UUID $rowClickEntityId = this.getRowClickEntityId();
        result = result * 59 + ($rowClickEntityId == null ? 43 : ((Object)$rowClickEntityId).hashCode());
        long $createdAt = this.getCreatedAt();
        result = result * 59 + (int)($createdAt >>> 32 ^ $createdAt);
        long $updatedAt = this.getUpdatedAt();
        result = result * 59 + (int)($updatedAt >>> 32 ^ $updatedAt);
        List $allFields = this.getAllFields();
        result = result * 59 + ($allFields == null ? 43 : ((Object)$allFields).hashCode());
        String $runtimeFilters = this.getRuntimeFilters();
        result = result * 59 + ($runtimeFilters == null ? 43 : $runtimeFilters.hashCode());
        String $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : $settings.hashCode());
        Boolean $useReportCache = this.getUseReportCache();
        result = result * 59 + ($useReportCache == null ? 43 : ((Object)$useReportCache).hashCode());
        Boolean $usePersistedCacheTelemetry = this.getUsePersistedCacheTelemetry();
        result = result * 59 + ($usePersistedCacheTelemetry == null ? 43 : ((Object)$usePersistedCacheTelemetry).hashCode());
        DateAggregationType $cachingDateAggregation = this.getCachingDateAggregation();
        result = result * 59 + ($cachingDateAggregation == null ? 43 : $cachingDateAggregation.hashCode());
        Boolean $autoRefreshCache = this.getAutoRefreshCache();
        result = result * 59 + ($autoRefreshCache == null ? 43 : ((Object)$autoRefreshCache).hashCode());
        UUID $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : ((Object)$taskId).hashCode());
        String $refreshFrequencyTimeUnit = this.getRefreshFrequencyTimeUnit();
        result = result * 59 + ($refreshFrequencyTimeUnit == null ? 43 : $refreshFrequencyTimeUnit.hashCode());
        Integer $refreshFrequencyTimeUnitCount = this.getRefreshFrequencyTimeUnitCount();
        result = result * 59 + ($refreshFrequencyTimeUnitCount == null ? 43 : ((Object)$refreshFrequencyTimeUnitCount).hashCode());
        String $datePickerConfig = this.getDatePickerConfig();
        result = result * 59 + ($datePickerConfig == null ? 43 : $datePickerConfig.hashCode());
        String $tzName = this.getTzName();
        result = result * 59 + ($tzName == null ? 43 : $tzName.hashCode());
        return result;
    }

    public String toString() {
        return "ViewConfigDto(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", name=" + this.getName() + ", viewType=" + this.getViewType() + ", configDefinition=" + this.getConfigDefinition() + ", rootEntityId=" + this.getRootEntityId() + ", rowClickEntityId=" + this.getRowClickEntityId() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", allFields=" + this.getAllFields() + ", runtimeFilters=" + this.getRuntimeFilters() + ", settings=" + this.getSettings() + ", useReportCache=" + this.getUseReportCache() + ", usePersistedCacheTelemetry=" + this.getUsePersistedCacheTelemetry() + ", cachingDateAggregation=" + this.getCachingDateAggregation() + ", autoRefreshCache=" + this.getAutoRefreshCache() + ", taskId=" + this.getTaskId() + ", refreshFrequencyTimeUnit=" + this.getRefreshFrequencyTimeUnit() + ", refreshFrequencyTimeUnitCount=" + this.getRefreshFrequencyTimeUnitCount() + ", datePickerConfig=" + this.getDatePickerConfig() + ", tzName=" + this.getTzName() + ")";
    }
}

