/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.sql;

import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.thingsboard.trendz.dao.sql.TaskDto;
import org.thingsboard.trendz.dao.sql.TaskProgressDto;
import org.thingsboard.trendz.task.Task;
import org.thingsboard.trendz.task.TaskProgress;
import org.thingsboard.trendz.task.TaskStatus;
import org.thingsboard.trendz.task.TaskType;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="task")
public class TaskDto {
    @Id
    @GenericGenerator(name="timestampUuidGenerator", strategy="org.thingsboard.trendz.dao.sql.TimeStampUUIDGenerator")
    @GeneratedValue(generator="timestampUuidGenerator")
    @Column(name="id")
    private UUID id;
    @Column(name="model_id")
    private UUID modelId;
    @Enumerated(value=EnumType.STRING)
    @Column(name="type")
    private TaskType type;
    @Enumerated(value=EnumType.STRING)
    @Column(name="status")
    private TaskStatus status;
    @Column(name="created_at")
    private long createdAt;
    @Column(name="started_at")
    private long startedAt;
    @Column(name="completed_at")
    private long completedAt;
    @Column(name="complete_reason")
    private String completeReason;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="progress_id", referencedColumnName="id")
    private TaskProgressDto progress;

    public Task toData() {
        return Task.builder().id(this.id).modelId(this.modelId).type(this.type).status(this.status).createdAt(this.createdAt).startedAt(this.startedAt).completedAt(this.completedAt).completeReason(this.completeReason).progress(this.progress == null ? null : this.progress.toData()).build();
    }

    public static TaskDto from(Task entity) {
        return TaskDto.builder().id(entity.getId()).modelId(entity.getModelId()).type(entity.getType()).status(entity.getStatus()).createdAt(entity.getCreatedAt()).startedAt(entity.getStartedAt()).completedAt(entity.getCompletedAt()).completeReason(entity.getCompleteReason()).progress(TaskProgressDto.from((TaskProgress)entity.getProgress())).build();
    }

    public static TaskDtoBuilder builder() {
        return new TaskDtoBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getModelId() {
        return this.modelId;
    }

    public TaskType getType() {
        return this.type;
    }

    public TaskStatus getStatus() {
        return this.status;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getStartedAt() {
        return this.startedAt;
    }

    public long getCompletedAt() {
        return this.completedAt;
    }

    public String getCompleteReason() {
        return this.completeReason;
    }

    public TaskProgressDto getProgress() {
        return this.progress;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setModelId(UUID modelId) {
        this.modelId = modelId;
    }

    public void setType(TaskType type) {
        this.type = type;
    }

    public void setStatus(TaskStatus status) {
        this.status = status;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public void setStartedAt(long startedAt) {
        this.startedAt = startedAt;
    }

    public void setCompletedAt(long completedAt) {
        this.completedAt = completedAt;
    }

    public void setCompleteReason(String completeReason) {
        this.completeReason = completeReason;
    }

    public void setProgress(TaskProgressDto progress) {
        this.progress = progress;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskDto)) {
            return false;
        }
        TaskDto other = (TaskDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$modelId = this.getModelId();
        UUID other$modelId = other.getModelId();
        if (this$modelId == null ? other$modelId != null : !((Object)this$modelId).equals(other$modelId)) {
            return false;
        }
        TaskType this$type = this.getType();
        TaskType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        TaskStatus this$status = this.getStatus();
        TaskStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        if (this.getCreatedAt() != other.getCreatedAt()) {
            return false;
        }
        if (this.getStartedAt() != other.getStartedAt()) {
            return false;
        }
        if (this.getCompletedAt() != other.getCompletedAt()) {
            return false;
        }
        String this$completeReason = this.getCompleteReason();
        String other$completeReason = other.getCompleteReason();
        if (this$completeReason == null ? other$completeReason != null : !this$completeReason.equals(other$completeReason)) {
            return false;
        }
        TaskProgressDto this$progress = this.getProgress();
        TaskProgressDto other$progress = other.getProgress();
        return !(this$progress == null ? other$progress != null : !this$progress.equals(other$progress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $modelId = this.getModelId();
        result = result * 59 + ($modelId == null ? 43 : ((Object)$modelId).hashCode());
        TaskType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        TaskStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        long $createdAt = this.getCreatedAt();
        result = result * 59 + (int)($createdAt >>> 32 ^ $createdAt);
        long $startedAt = this.getStartedAt();
        result = result * 59 + (int)($startedAt >>> 32 ^ $startedAt);
        long $completedAt = this.getCompletedAt();
        result = result * 59 + (int)($completedAt >>> 32 ^ $completedAt);
        String $completeReason = this.getCompleteReason();
        result = result * 59 + ($completeReason == null ? 43 : $completeReason.hashCode());
        TaskProgressDto $progress = this.getProgress();
        result = result * 59 + ($progress == null ? 43 : $progress.hashCode());
        return result;
    }

    public String toString() {
        return "TaskDto(id=" + this.getId() + ", modelId=" + this.getModelId() + ", type=" + this.getType() + ", status=" + this.getStatus() + ", createdAt=" + this.getCreatedAt() + ", startedAt=" + this.getStartedAt() + ", completedAt=" + this.getCompletedAt() + ", completeReason=" + this.getCompleteReason() + ", progress=" + this.getProgress() + ")";
    }

    public TaskDto() {
    }

    public TaskDto(UUID id, UUID modelId, TaskType type, TaskStatus status, long createdAt, long startedAt, long completedAt, String completeReason, TaskProgressDto progress) {
        this.id = id;
        this.modelId = modelId;
        this.type = type;
        this.status = status;
        this.createdAt = createdAt;
        this.startedAt = startedAt;
        this.completedAt = completedAt;
        this.completeReason = completeReason;
        this.progress = progress;
    }
}

