/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.sql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.UUID;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.thingsboard.trendz.dao.sql.RelationId;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;
import org.thingsboard.trendz.domain.definition.entity.relation.RelationQuery;
import org.thingsboard.trendz.domain.definition.entity.relation.TbRelationQuery;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity(name="relation")
@Table(name="relation")
public class RelationEntity {
    @Transient
    private static final ObjectMapper mapper = new ObjectMapper();
    @EmbeddedId
    private RelationId relationId;
    private boolean enabled;
    @JsonDeserialize(as=TbRelationQuery.class)
    private String query;

    public Relation toData() {
        Relation relation = new Relation();
        relation.setRelatedEntityId(this.relationId.getRelatedEntityId());
        relation.setName(this.relationId.getName());
        relation.setEnabled(this.enabled);
        try {
            relation.setQuery((RelationQuery)mapper.readValue(this.query, TbRelationQuery.class));
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not deserialize Relation query from DB: " + this.relationId + "  json: " + this.query, e);
        }
        return relation;
    }

    public static RelationEntity from(UUID beId, Relation entity) {
        RelationEntity relationEntity = new RelationEntity();
        RelationId build = RelationId.builder().from(beId).relatedEntityId(entity.getRelatedEntityId()).name(entity.getName()).direction(RelationEntity.getDirection((RelationQuery)entity.getQuery())).build();
        relationEntity.setRelationId(build);
        relationEntity.setEnabled(entity.isEnabled());
        try {
            String sQuery = mapper.writeValueAsString((Object)entity.getQuery());
            relationEntity.setQuery(sQuery);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Could not serialize Business Entity query to DTO: " + entity, e);
        }
        return relationEntity;
    }

    private static String getDirection(RelationQuery query) {
        if (query instanceof TbRelationQuery) {
            return ((TbRelationQuery)query).getDirection().name();
        }
        return "";
    }

    public RelationId getRelationId() {
        return this.relationId;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getQuery() {
        return this.query;
    }

    public void setRelationId(RelationId relationId) {
        this.relationId = relationId;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelationEntity)) {
            return false;
        }
        RelationEntity other = (RelationEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        RelationId this$relationId = this.getRelationId();
        RelationId other$relationId = other.getRelationId();
        if (this$relationId == null ? other$relationId != null : !this$relationId.equals(other$relationId)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        return !(this$query == null ? other$query != null : !this$query.equals(other$query));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RelationEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RelationId $relationId = this.getRelationId();
        result = result * 59 + ($relationId == null ? 43 : $relationId.hashCode());
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        return result;
    }

    public String toString() {
        return "RelationEntity(relationId=" + this.getRelationId() + ", enabled=" + this.isEnabled() + ", query=" + this.getQuery() + ")";
    }
}

