/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.sql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.thingsboard.trendz.dao.sql.MlPropertiesDto;
import org.thingsboard.trendz.ml.domain.MlProperties;

@Entity
@Table(name="ml_properties")
public class MlPropertiesDto {
    private static final ObjectMapper mapper = new ObjectMapper();
    @Id
    @GenericGenerator(name="timestampUuidGenerator", strategy="org.thingsboard.trendz.dao.sql.TimeStampUUIDGenerator")
    @GeneratedValue(generator="timestampUuidGenerator")
    @Column(name="id")
    private UUID id;
    @Column(name="json_value")
    private String rawJson;

    public MlProperties toData() {
        try {
            MlProperties data = (MlProperties)mapper.readValue(this.rawJson, MlProperties.class);
            data.setId(this.id);
            return data;
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not deserialize ML Properties from DB: " + this.id + "  json: " + this.rawJson, e);
        }
    }

    public static MlPropertiesDto from(MlProperties entity) {
        try {
            String raw = mapper.writeValueAsString((Object)entity);
            MlPropertiesDto dto = new MlPropertiesDto();
            dto.setId(entity.getId());
            dto.setRawJson(raw);
            return dto;
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Could not serialize ML Properties to DTO: " + entity, e);
        }
    }

    public static MlPropertiesDtoBuilder builder() {
        return new MlPropertiesDtoBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public String getRawJson() {
        return this.rawJson;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setRawJson(String rawJson) {
        this.rawJson = rawJson;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MlPropertiesDto)) {
            return false;
        }
        MlPropertiesDto other = (MlPropertiesDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$rawJson = this.getRawJson();
        String other$rawJson = other.getRawJson();
        return !(this$rawJson == null ? other$rawJson != null : !this$rawJson.equals(other$rawJson));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MlPropertiesDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $rawJson = this.getRawJson();
        result = result * 59 + ($rawJson == null ? 43 : $rawJson.hashCode());
        return result;
    }

    public String toString() {
        return "MlPropertiesDto(id=" + this.getId() + ", rawJson=" + this.getRawJson() + ")";
    }

    public MlPropertiesDto() {
    }

    public MlPropertiesDto(UUID id, String rawJson) {
        this.id = id;
        this.rawJson = rawJson;
    }
}

