/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.dao.sql.DatasetConfigDto;
import org.thingsboard.trendz.dao.sql.RuntimeFilterFieldDto;
import org.thingsboard.trendz.dao.sql.ViewFieldDto;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.ml.domain.DatasetConfig;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="dataset_config")
public class DatasetConfigDto {
    @Id
    @GenericGenerator(name="timestampUuidGenerator", strategy="org.thingsboard.trendz.dao.sql.TimeStampUUIDGenerator")
    @GeneratedValue(generator="timestampUuidGenerator")
    @Column(name="id")
    private UUID id;
    @Column(name="max_points_count")
    private int maxPointsCount;
    @Column(name="start_ts")
    private long startTs;
    @Column(name="end_ts")
    private long endTs;
    @Column(name="tenant_id")
    private UUID tenantId;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SUBSELECT)
    @JoinColumn(name="dataset_config_id")
    private List<ViewFieldDto> fields;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SUBSELECT)
    @JoinColumn(name="dataset_config_id")
    private List<RuntimeFilterFieldDto> runtimeFilters;

    public DatasetConfig toData() {
        List fields = this.fields == null ? Collections.emptyList() : this.fields.stream().filter(field -> !field.isHidden()).map(ViewFieldDto::toData).collect(Collectors.toList());
        List hiddenFields = this.fields == null ? Collections.emptyList() : this.fields.stream().filter(ViewFieldDto::isHidden).map(ViewFieldDto::toData).collect(Collectors.toList());
        List runtimeFilters = this.runtimeFilters == null ? Collections.emptyList() : this.runtimeFilters.stream().map(RuntimeFilterFieldDto::toData).collect(Collectors.toList());
        return DatasetConfig.builder().id(this.id).fields(fields).hiddenFields(hiddenFields).runtimeFilters(runtimeFilters).maxPointsCount(this.maxPointsCount).startTs(this.startTs).endTs(this.endTs).tenantId(new TenantId(this.tenantId)).jwtToken(null).build();
    }

    public static DatasetConfigDto from(DatasetConfig entity) {
        ArrayList allFields = new ArrayList();
        if (entity.getFields() != null) {
            allFields.addAll(entity.getFields().stream().map(field -> ViewFieldDto.from(null, (ViewField)field, null)).collect(Collectors.toList()));
        }
        if (entity.getHiddenFields() != null) {
            allFields.addAll(entity.getHiddenFields().stream().map(field -> ViewFieldDto.from(null, (ViewField)field, null)).collect(Collectors.toList()));
        }
        return DatasetConfigDto.builder().id(entity.getId()).maxPointsCount(entity.getMaxPointsCount()).startTs(entity.getStartTs()).endTs(entity.getEndTs()).tenantId(entity.getTenantId().getId()).fields(allFields).runtimeFilters(entity.getRuntimeFilters() == null ? Collections.emptyList() : entity.getRuntimeFilters().stream().map(RuntimeFilterFieldDto::from).collect(Collectors.toList())).build();
    }

    public static DatasetConfigDtoBuilder builder() {
        return new DatasetConfigDtoBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public int getMaxPointsCount() {
        return this.maxPointsCount;
    }

    public long getStartTs() {
        return this.startTs;
    }

    public long getEndTs() {
        return this.endTs;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public List<ViewFieldDto> getFields() {
        return this.fields;
    }

    public List<RuntimeFilterFieldDto> getRuntimeFilters() {
        return this.runtimeFilters;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setMaxPointsCount(int maxPointsCount) {
        this.maxPointsCount = maxPointsCount;
    }

    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    public void setEndTs(long endTs) {
        this.endTs = endTs;
    }

    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    public void setFields(List<ViewFieldDto> fields) {
        this.fields = fields;
    }

    public void setRuntimeFilters(List<RuntimeFilterFieldDto> runtimeFilters) {
        this.runtimeFilters = runtimeFilters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatasetConfigDto)) {
            return false;
        }
        DatasetConfigDto other = (DatasetConfigDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        if (this.getMaxPointsCount() != other.getMaxPointsCount()) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.getEndTs() != other.getEndTs()) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        List this$fields = this.getFields();
        List other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        List this$runtimeFilters = this.getRuntimeFilters();
        List other$runtimeFilters = other.getRuntimeFilters();
        return !(this$runtimeFilters == null ? other$runtimeFilters != null : !((Object)this$runtimeFilters).equals(other$runtimeFilters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DatasetConfigDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        result = result * 59 + this.getMaxPointsCount();
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $endTs = this.getEndTs();
        result = result * 59 + (int)($endTs >>> 32 ^ $endTs);
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        List $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        List $runtimeFilters = this.getRuntimeFilters();
        result = result * 59 + ($runtimeFilters == null ? 43 : ((Object)$runtimeFilters).hashCode());
        return result;
    }

    public String toString() {
        return "DatasetConfigDto(id=" + this.getId() + ", maxPointsCount=" + this.getMaxPointsCount() + ", startTs=" + this.getStartTs() + ", endTs=" + this.getEndTs() + ", tenantId=" + this.getTenantId() + ", fields=" + this.getFields() + ", runtimeFilters=" + this.getRuntimeFilters() + ")";
    }

    public DatasetConfigDto() {
    }

    public DatasetConfigDto(UUID id, int maxPointsCount, long startTs, long endTs, UUID tenantId, List<ViewFieldDto> fields, List<RuntimeFilterFieldDto> runtimeFilters) {
        this.id = id;
        this.maxPointsCount = maxPointsCount;
        this.startTs = startTs;
        this.endTs = endTs;
        this.tenantId = tenantId;
        this.fields = fields;
        this.runtimeFilters = runtimeFilters;
    }
}

