/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.sql;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.thingsboard.trendz.dao.sql.ClusterInfoDto;
import org.thingsboard.trendz.dao.sql.ClusterModelDto;
import org.thingsboard.trendz.dao.sql.DatasetConfigDto;
import org.thingsboard.trendz.dao.sql.MlPropertiesDto;
import org.thingsboard.trendz.ml.domain.ClusterInfo;
import org.thingsboard.trendz.ml.domain.ClusterModel;
import org.thingsboard.trendz.ml.domain.DatasetConfig;
import org.thingsboard.trendz.ml.domain.MlProperties;
import org.thingsboard.trendz.ml.domain.ModelStatus;
import org.thingsboard.trendz.ml.domain.ModelType;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="cluster_model")
public class ClusterModelDto {
    @Id
    @Column(name="id")
    private UUID id;
    @Column(name="tenant_id")
    private UUID tenantId;
    @Column(name="create_ts")
    private long createTs;
    @Column(name="name")
    private String name;
    @Enumerated(value=EnumType.STRING)
    @Column(name="status")
    private ModelStatus status;
    @Enumerated(value=EnumType.STRING)
    @Column(name="type")
    private ModelType type;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="properties_id", referencedColumnName="id")
    private MlPropertiesDto properties;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="dataset_config_id", referencedColumnName="id")
    private DatasetConfigDto datasetConfig;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="cluster_model_id", referencedColumnName="id")
    private List<ClusterInfoDto> clusters;

    public ClusterModel toData() {
        List clusters = this.clusters == null ? Collections.emptyList() : this.clusters.stream().map(ClusterInfoDto::toData).collect(Collectors.toList());
        return ClusterModel.builder().id(this.id).tenantId(this.tenantId).createTs(this.createTs).name(this.name).status(this.status).type(this.type).properties(this.properties.toData()).datasetConfig(this.datasetConfig.toData()).clusters(clusters).build();
    }

    public static ClusterModelDto from(ClusterModel entity) {
        return ClusterModelDto.builder().id(entity.getId()).tenantId(entity.getTenantId()).createTs(entity.getCreateTs()).name(entity.getName()).status(entity.getStatus()).type(entity.getType()).properties(MlPropertiesDto.from((MlProperties)entity.getProperties())).datasetConfig(DatasetConfigDto.from((DatasetConfig)entity.getDatasetConfig())).clusters(entity.getClusters().stream().map(cluster -> ClusterInfoDto.from((ClusterInfo)cluster, (UUID)entity.getId())).collect(Collectors.toList())).build();
    }

    public static ClusterModelDtoBuilder builder() {
        return new ClusterModelDtoBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public long getCreateTs() {
        return this.createTs;
    }

    public String getName() {
        return this.name;
    }

    public ModelStatus getStatus() {
        return this.status;
    }

    public ModelType getType() {
        return this.type;
    }

    public MlPropertiesDto getProperties() {
        return this.properties;
    }

    public DatasetConfigDto getDatasetConfig() {
        return this.datasetConfig;
    }

    public List<ClusterInfoDto> getClusters() {
        return this.clusters;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    public void setCreateTs(long createTs) {
        this.createTs = createTs;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStatus(ModelStatus status) {
        this.status = status;
    }

    public void setType(ModelType type) {
        this.type = type;
    }

    public void setProperties(MlPropertiesDto properties) {
        this.properties = properties;
    }

    public void setDatasetConfig(DatasetConfigDto datasetConfig) {
        this.datasetConfig = datasetConfig;
    }

    public void setClusters(List<ClusterInfoDto> clusters) {
        this.clusters = clusters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterModelDto)) {
            return false;
        }
        ClusterModelDto other = (ClusterModelDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        if (this.getCreateTs() != other.getCreateTs()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ModelStatus this$status = this.getStatus();
        ModelStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        ModelType this$type = this.getType();
        ModelType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        MlPropertiesDto this$properties = this.getProperties();
        MlPropertiesDto other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !this$properties.equals(other$properties)) {
            return false;
        }
        DatasetConfigDto this$datasetConfig = this.getDatasetConfig();
        DatasetConfigDto other$datasetConfig = other.getDatasetConfig();
        if (this$datasetConfig == null ? other$datasetConfig != null : !this$datasetConfig.equals(other$datasetConfig)) {
            return false;
        }
        List this$clusters = this.getClusters();
        List other$clusters = other.getClusters();
        return !(this$clusters == null ? other$clusters != null : !((Object)this$clusters).equals(other$clusters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClusterModelDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        long $createTs = this.getCreateTs();
        result = result * 59 + (int)($createTs >>> 32 ^ $createTs);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ModelStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        ModelType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        MlPropertiesDto $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        DatasetConfigDto $datasetConfig = this.getDatasetConfig();
        result = result * 59 + ($datasetConfig == null ? 43 : $datasetConfig.hashCode());
        List $clusters = this.getClusters();
        result = result * 59 + ($clusters == null ? 43 : ((Object)$clusters).hashCode());
        return result;
    }

    public String toString() {
        return "ClusterModelDto(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", createTs=" + this.getCreateTs() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", type=" + this.getType() + ", properties=" + this.getProperties() + ", datasetConfig=" + this.getDatasetConfig() + ", clusters=" + this.getClusters() + ")";
    }

    public ClusterModelDto() {
    }

    public ClusterModelDto(UUID id, UUID tenantId, long createTs, String name, ModelStatus status, ModelType type, MlPropertiesDto properties, DatasetConfigDto datasetConfig, List<ClusterInfoDto> clusters) {
        this.id = id;
        this.tenantId = tenantId;
        this.createTs = createTs;
        this.name = name;
        this.status = status;
        this.type = type;
        this.properties = properties;
        this.datasetConfig = datasetConfig;
        this.clusters = clusters;
    }
}

