/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vladmihalcea.hibernate.type.array.ListArrayType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityFieldQuery;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.entity.field.TbBusinessEntityFieldQuery;

@Entity
@Table(name="business_entity_field")
@TypeDef(name="list-array", typeClass=ListArrayType.class)
public class BusinessEntityFieldDto {
    @Transient
    private static final ObjectMapper mapper = new ObjectMapper();
    @Id
    private UUID id;
    @Column(name="business_entity_id")
    private UUID businessEntityId;
    private String name;
    private String description;
    private String calcFunction;
    private boolean hidden;
    @Type(type="list-array")
    @Column(name="options", columnDefinition="text[]")
    private List<String> options;
    private String type;
    private String query;

    public BusinessEntityField toData() {
        BusinessEntityField businessEntityField = new BusinessEntityField();
        businessEntityField.setId(this.id);
        businessEntityField.setBusinessEntityId(this.businessEntityId);
        businessEntityField.setName(this.name);
        businessEntityField.setDescription(this.description);
        businessEntityField.setHidden(this.hidden);
        businessEntityField.setCalcFunction(this.calcFunction);
        businessEntityField.setOptions(new HashSet(this.options));
        businessEntityField.setType(FieldType.valueOf((String)this.type));
        try {
            businessEntityField.setQuery((BusinessEntityFieldQuery)mapper.readValue(this.query, TbBusinessEntityFieldQuery.class));
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not deserialize Business Entity Field " + this.query, e);
        }
        return businessEntityField;
    }

    public static BusinessEntityFieldDto from(BusinessEntityField entity) {
        BusinessEntityFieldDto dto = new BusinessEntityFieldDto();
        dto.setId(entity.getId());
        dto.setBusinessEntityId(entity.getBusinessEntityId());
        dto.setDescription(entity.getDescription());
        dto.setName(entity.getName());
        dto.setHidden(entity.isHidden());
        dto.setCalcFunction(entity.getCalcFunction());
        Set opts = entity.getOptions() != null ? entity.getOptions() : Collections.emptySet();
        dto.setOptions(new ArrayList(opts));
        try {
            dto.setQuery(mapper.writeValueAsString((Object)entity.getQuery()));
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not deserialize Business Entity Field", e);
        }
        dto.setType(entity.getType().name());
        return dto;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getBusinessEntityId() {
        return this.businessEntityId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCalcFunction() {
        return this.calcFunction;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public String getType() {
        return this.type;
    }

    public String getQuery() {
        return this.query;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setBusinessEntityId(UUID businessEntityId) {
        this.businessEntityId = businessEntityId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCalcFunction(String calcFunction) {
        this.calcFunction = calcFunction;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setOptions(List<String> options) {
        this.options = options;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessEntityFieldDto)) {
            return false;
        }
        BusinessEntityFieldDto other = (BusinessEntityFieldDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$businessEntityId = this.getBusinessEntityId();
        UUID other$businessEntityId = other.getBusinessEntityId();
        if (this$businessEntityId == null ? other$businessEntityId != null : !((Object)this$businessEntityId).equals(other$businessEntityId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$calcFunction = this.getCalcFunction();
        String other$calcFunction = other.getCalcFunction();
        if (this$calcFunction == null ? other$calcFunction != null : !this$calcFunction.equals(other$calcFunction)) {
            return false;
        }
        if (this.isHidden() != other.isHidden()) {
            return false;
        }
        List this$options = this.getOptions();
        List other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        return !(this$query == null ? other$query != null : !this$query.equals(other$query));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BusinessEntityFieldDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $businessEntityId = this.getBusinessEntityId();
        result = result * 59 + ($businessEntityId == null ? 43 : ((Object)$businessEntityId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $calcFunction = this.getCalcFunction();
        result = result * 59 + ($calcFunction == null ? 43 : $calcFunction.hashCode());
        result = result * 59 + (this.isHidden() ? 79 : 97);
        List $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        return result;
    }

    public String toString() {
        return "BusinessEntityFieldDto(id=" + this.getId() + ", businessEntityId=" + this.getBusinessEntityId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", calcFunction=" + this.getCalcFunction() + ", hidden=" + this.isHidden() + ", options=" + this.getOptions() + ", type=" + this.getType() + ", query=" + this.getQuery() + ")";
    }
}

