/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.sql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.springframework.util.CollectionUtils;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.dao.sql.BusinessEntityFieldDto;
import org.thingsboard.trendz.dao.sql.RelationEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityQuery;
import org.thingsboard.trendz.domain.definition.entity.TbBusinessEntityQuery;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;

@Entity(name="business_entity")
@Table(name="business_entity")
public class BusinessEntityDto {
    @Transient
    private static final ObjectMapper mapper = new ObjectMapper();
    @Id
    private UUID id;
    @Column(name="tenant_id")
    private UUID tenantId;
    private String name;
    private String description;
    private boolean hidden;
    private String query;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="business_entity_id", updatable=false)
    private Set<BusinessEntityFieldDto> fields;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="business_entity_id", updatable=false)
    private Set<RelationEntity> relations;

    public BusinessEntity toData() {
        BusinessEntity businessEntity = new BusinessEntity();
        businessEntity.setId(this.id);
        businessEntity.setName(this.name);
        businessEntity.setDescription(this.description);
        businessEntity.setHidden(this.hidden);
        businessEntity.setFields(this.fields.stream().map(BusinessEntityFieldDto::toData).peek(f -> f.setBusinessEntityId(this.id)).collect(Collectors.toList()));
        if (!CollectionUtils.isEmpty((Collection)this.relations)) {
            businessEntity.setRelations(this.relations.stream().map(RelationEntity::toData).collect(Collectors.toList()));
        }
        try {
            businessEntity.setQuery((BusinessEntityQuery)mapper.readValue(this.query, TbBusinessEntityQuery.class));
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not deserialize Business Entity query from DB: " + this.id + "  json: " + this.query, e);
        }
        return businessEntity;
    }

    public static BusinessEntityDto from(TenantId tenantId, BusinessEntity entity) {
        BusinessEntityDto dto = new BusinessEntityDto();
        dto.setId(entity.getId());
        dto.setTenantId(tenantId.getId());
        dto.setName(entity.getName());
        dto.setDescription(entity.getDescription());
        dto.setHidden(entity.isHidden());
        dto.setFields(entity.getFields().stream().map(BusinessEntityFieldDto::from).peek(f -> f.setBusinessEntityId(dto.getId())).collect(Collectors.toSet()));
        if (!CollectionUtils.isEmpty((Collection)entity.getRelations())) {
            dto.setRelations(entity.getRelations().stream().filter(Objects::nonNull).map(r -> RelationEntity.from((UUID)entity.getId(), (Relation)r)).collect(Collectors.toSet()));
        } else {
            dto.setRelations(new HashSet());
        }
        try {
            String sQuery = mapper.writeValueAsString((Object)entity.getQuery());
            dto.setQuery(sQuery);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Could not serialize Business Entity query to DTO: " + entity, e);
        }
        return dto;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getQuery() {
        return this.query;
    }

    public Set<BusinessEntityFieldDto> getFields() {
        return this.fields;
    }

    public Set<RelationEntity> getRelations() {
        return this.relations;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setFields(Set<BusinessEntityFieldDto> fields) {
        this.fields = fields;
    }

    public void setRelations(Set<RelationEntity> relations) {
        this.relations = relations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessEntityDto)) {
            return false;
        }
        BusinessEntityDto other = (BusinessEntityDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        if (this.isHidden() != other.isHidden()) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        Set this$fields = this.getFields();
        Set other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        Set this$relations = this.getRelations();
        Set other$relations = other.getRelations();
        return !(this$relations == null ? other$relations != null : !((Object)this$relations).equals(other$relations));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BusinessEntityDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        result = result * 59 + (this.isHidden() ? 79 : 97);
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        Set $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        Set $relations = this.getRelations();
        result = result * 59 + ($relations == null ? 43 : ((Object)$relations).hashCode());
        return result;
    }

    public String toString() {
        return "BusinessEntityDto(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", hidden=" + this.isHidden() + ", query=" + this.getQuery() + ", fields=" + this.getFields() + ", relations=" + this.getRelations() + ")";
    }
}

