/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.scheduledtask;

import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.thingsboard.trendz.dao.scheduledtask.ScheduledTaskHistoryRecordDto;
import org.thingsboard.trendz.service.scheduledtask.ScheduledTaskHistoryRecord;
import org.thingsboard.trendz.service.scheduledtask.ScheduledTaskHistoryStatus;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="scheduled_task_history_record")
public class ScheduledTaskHistoryRecordDto {
    @Id
    @GenericGenerator(name="timestampUuidGenerator", strategy="org.thingsboard.trendz.dao.sql.TimeStampUUIDGenerator")
    @GeneratedValue(generator="timestampUuidGenerator")
    @Column(name="id")
    private UUID id;
    @Column(name="scheduled_task_id")
    private UUID scheduledTaskId;
    @Column(name="recordTimestamp")
    private long recordTimestamp;
    @Column(name="duration")
    private long duration;
    @Enumerated(value=EnumType.STRING)
    @Column(name="status")
    private ScheduledTaskHistoryStatus status;
    @Column(name="failure_reason")
    private String failureReason;

    public ScheduledTaskHistoryRecord toData() {
        return ScheduledTaskHistoryRecord.builder().id(this.id).scheduledTaskId(this.scheduledTaskId).recordTimestamp(this.recordTimestamp).duration(this.duration).status(this.status).failureReason(this.failureReason).build();
    }

    public static ScheduledTaskHistoryRecordDto from(ScheduledTaskHistoryRecord entity) {
        return ScheduledTaskHistoryRecordDto.builder().id(entity.getId()).scheduledTaskId(entity.getScheduledTaskId()).recordTimestamp(entity.getRecordTimestamp()).duration(entity.getDuration()).status(entity.getStatus()).failureReason(entity.getFailureReason()).build();
    }

    public static ScheduledTaskHistoryRecordDtoBuilder builder() {
        return new ScheduledTaskHistoryRecordDtoBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getScheduledTaskId() {
        return this.scheduledTaskId;
    }

    public long getRecordTimestamp() {
        return this.recordTimestamp;
    }

    public long getDuration() {
        return this.duration;
    }

    public ScheduledTaskHistoryStatus getStatus() {
        return this.status;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setScheduledTaskId(UUID scheduledTaskId) {
        this.scheduledTaskId = scheduledTaskId;
    }

    public void setRecordTimestamp(long recordTimestamp) {
        this.recordTimestamp = recordTimestamp;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setStatus(ScheduledTaskHistoryStatus status) {
        this.status = status;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScheduledTaskHistoryRecordDto)) {
            return false;
        }
        ScheduledTaskHistoryRecordDto other = (ScheduledTaskHistoryRecordDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$scheduledTaskId = this.getScheduledTaskId();
        UUID other$scheduledTaskId = other.getScheduledTaskId();
        if (this$scheduledTaskId == null ? other$scheduledTaskId != null : !((Object)this$scheduledTaskId).equals(other$scheduledTaskId)) {
            return false;
        }
        if (this.getRecordTimestamp() != other.getRecordTimestamp()) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        ScheduledTaskHistoryStatus this$status = this.getStatus();
        ScheduledTaskHistoryStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$failureReason = this.getFailureReason();
        String other$failureReason = other.getFailureReason();
        return !(this$failureReason == null ? other$failureReason != null : !this$failureReason.equals(other$failureReason));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScheduledTaskHistoryRecordDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $scheduledTaskId = this.getScheduledTaskId();
        result = result * 59 + ($scheduledTaskId == null ? 43 : ((Object)$scheduledTaskId).hashCode());
        long $recordTimestamp = this.getRecordTimestamp();
        result = result * 59 + (int)($recordTimestamp >>> 32 ^ $recordTimestamp);
        long $duration = this.getDuration();
        result = result * 59 + (int)($duration >>> 32 ^ $duration);
        ScheduledTaskHistoryStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $failureReason = this.getFailureReason();
        result = result * 59 + ($failureReason == null ? 43 : $failureReason.hashCode());
        return result;
    }

    public String toString() {
        return "ScheduledTaskHistoryRecordDto(id=" + this.getId() + ", scheduledTaskId=" + this.getScheduledTaskId() + ", recordTimestamp=" + this.getRecordTimestamp() + ", duration=" + this.getDuration() + ", status=" + this.getStatus() + ", failureReason=" + this.getFailureReason() + ")";
    }

    public ScheduledTaskHistoryRecordDto() {
    }

    public ScheduledTaskHistoryRecordDto(UUID id, UUID scheduledTaskId, long recordTimestamp, long duration, ScheduledTaskHistoryStatus status, String failureReason) {
        this.id = id;
        this.scheduledTaskId = scheduledTaskId;
        this.recordTimestamp = recordTimestamp;
        this.duration = duration;
        this.status = status;
        this.failureReason = failureReason;
    }
}

