/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.scheduledtask;

import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.dao.scheduledtask.ScheduledTaskHistoryRecordDto;
import org.thingsboard.trendz.dao.scheduledtask.ScheduledTaskHistoryRecordRepository;
import org.thingsboard.trendz.service.scheduledtask.ScheduledTaskHistoryRecord;

@Component
@Transactional
public class ScheduledTaskHistoryRecordDao {
    private static final Logger log = LoggerFactory.getLogger(ScheduledTaskHistoryRecordDao.class);
    @Autowired
    private ScheduledTaskHistoryRecordRepository scheduledTaskHistoryRecordRepository;

    public ScheduledTaskHistoryRecord saveRecord(ScheduledTaskHistoryRecord record) {
        return ((ScheduledTaskHistoryRecordDto)this.scheduledTaskHistoryRecordRepository.save((Object)ScheduledTaskHistoryRecordDto.from((ScheduledTaskHistoryRecord)record))).toData();
    }

    public List<ScheduledTaskHistoryRecord> getAllRecordsForScheduledTask(UUID taskId) {
        List dtos = this.scheduledTaskHistoryRecordRepository.getAllRecordsByTaskId(taskId);
        List<ScheduledTaskHistoryRecord> records = dtos.stream().map(ScheduledTaskHistoryRecordDto::toData).sorted(Comparator.comparingLong(ScheduledTaskHistoryRecord::getRecordTimestamp)).collect(Collectors.toList());
        return records;
    }

    public void removeAllRecordsForScheduledTask(UUID taskId) {
        this.scheduledTaskHistoryRecordRepository.removeAllRecordsByTaskId(taskId);
    }
}

