/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.scheduledtask;

import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.dao.scheduledtask.ScheduledTaskDto;
import org.thingsboard.trendz.service.scheduledtask.ScheduledJobCollection;
import org.thingsboard.trendz.service.scheduledtask.ScheduledTask;
import org.thingsboard.trendz.service.scheduledtask.SchedulingConfig;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="scheduled_task")
public class ScheduledTaskDto {
    @Id
    @GenericGenerator(name="timestampUuidGenerator", strategy="org.thingsboard.trendz.dao.sql.TimeStampUUIDGenerator")
    @GeneratedValue(generator="timestampUuidGenerator")
    @Column(name="id")
    private UUID id;
    @Column(name="tenant_id")
    private UUID tenantId;
    @Column(name="enabled")
    private boolean enabled;
    @Column(name="initial_delay")
    private long initialDelay;
    @Column(name="regular_delay")
    private long regularDelay;
    @Column(name="delay_time_unit")
    private String delayTimeUnit;

    public ScheduledTask toData() {
        return ScheduledTask.builder().id(this.id).tenantId(new TenantId(this.tenantId)).enabled(this.enabled).schedulingConfig(SchedulingConfig.builder().initialDelay(this.initialDelay).regularDelay(this.regularDelay).delayTimeUnit(TimeUnit.valueOf(this.delayTimeUnit)).build()).scheduledJobCollection(new ScheduledJobCollection(new ArrayList())).build();
    }

    public static ScheduledTaskDto from(ScheduledTask entity) {
        String delayTimeUnit = entity.getSchedulingConfig().getDelayTimeUnit().name();
        return ScheduledTaskDto.builder().id(entity.getId()).tenantId(entity.getTenantId().getId()).enabled(entity.isEnabled()).initialDelay(entity.getSchedulingConfig().getInitialDelay()).regularDelay(entity.getSchedulingConfig().getRegularDelay()).delayTimeUnit(delayTimeUnit).build();
    }

    public static ScheduledTaskDtoBuilder builder() {
        return new ScheduledTaskDtoBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public long getRegularDelay() {
        return this.regularDelay;
    }

    public String getDelayTimeUnit() {
        return this.delayTimeUnit;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setInitialDelay(long initialDelay) {
        this.initialDelay = initialDelay;
    }

    public void setRegularDelay(long regularDelay) {
        this.regularDelay = regularDelay;
    }

    public void setDelayTimeUnit(String delayTimeUnit) {
        this.delayTimeUnit = delayTimeUnit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScheduledTaskDto)) {
            return false;
        }
        ScheduledTaskDto other = (ScheduledTaskDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getInitialDelay() != other.getInitialDelay()) {
            return false;
        }
        if (this.getRegularDelay() != other.getRegularDelay()) {
            return false;
        }
        String this$delayTimeUnit = this.getDelayTimeUnit();
        String other$delayTimeUnit = other.getDelayTimeUnit();
        return !(this$delayTimeUnit == null ? other$delayTimeUnit != null : !this$delayTimeUnit.equals(other$delayTimeUnit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScheduledTaskDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        long $initialDelay = this.getInitialDelay();
        result = result * 59 + (int)($initialDelay >>> 32 ^ $initialDelay);
        long $regularDelay = this.getRegularDelay();
        result = result * 59 + (int)($regularDelay >>> 32 ^ $regularDelay);
        String $delayTimeUnit = this.getDelayTimeUnit();
        result = result * 59 + ($delayTimeUnit == null ? 43 : $delayTimeUnit.hashCode());
        return result;
    }

    public String toString() {
        return "ScheduledTaskDto(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", enabled=" + this.isEnabled() + ", initialDelay=" + this.getInitialDelay() + ", regularDelay=" + this.getRegularDelay() + ", delayTimeUnit=" + this.getDelayTimeUnit() + ")";
    }

    public ScheduledTaskDto() {
    }

    public ScheduledTaskDto(UUID id, UUID tenantId, boolean enabled, long initialDelay, long regularDelay, String delayTimeUnit) {
        this.id = id;
        this.tenantId = tenantId;
        this.enabled = enabled;
        this.initialDelay = initialDelay;
        this.regularDelay = regularDelay;
        this.delayTimeUnit = delayTimeUnit;
    }
}

