/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.scheduledtask;

import com.clearspring.analytics.util.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.dao.scheduledtask.ScheduledJobDto;
import org.thingsboard.trendz.dao.scheduledtask.ScheduledJobRepository;
import org.thingsboard.trendz.dao.scheduledtask.ScheduledTaskDto;
import org.thingsboard.trendz.dao.scheduledtask.ScheduledTaskRepository;
import org.thingsboard.trendz.service.scheduledtask.ScheduledJob;
import org.thingsboard.trendz.service.scheduledtask.ScheduledJobCollection;
import org.thingsboard.trendz.service.scheduledtask.ScheduledTask;

@Component
@Transactional
public class ScheduledTaskDao {
    private static final Logger log = LoggerFactory.getLogger(ScheduledTaskDao.class);
    @Autowired
    private ScheduledTaskRepository scheduledTaskRepository;
    @Autowired
    private ScheduledJobRepository scheduledJobRepository;

    public List<ScheduledTask> getAll(TenantId tenantId) {
        List<ScheduledTask> tasks = this.scheduledTaskRepository.findAllByTenantId(tenantId.getId()).stream().map(ScheduledTaskDto::toData).collect(Collectors.toList());
        this.loadJobsForGivenTasks(tasks);
        return tasks;
    }

    public List<ScheduledTask> getAllEnabled(TenantId tenantId) {
        List<ScheduledTask> tasks = this.scheduledTaskRepository.findAllEnabledByTenantId(tenantId.getId()).stream().map(ScheduledTaskDto::toData).collect(Collectors.toList());
        this.loadJobsForGivenTasks(tasks);
        return tasks;
    }

    public ScheduledTask getById(UUID id) {
        ScheduledTask task = this.scheduledTaskRepository.findById((Object)id).map(ScheduledTaskDto::toData).orElse(null);
        if (task != null) {
            List jobs = this.scheduledJobRepository.getJobListByTaskId(id).stream().map(ScheduledJobDto::toData).collect(Collectors.toList());
            task.getScheduledJobCollection().getScheduledJobs().addAll(jobs);
        }
        return task;
    }

    public ScheduledTask save(ScheduledTask task) {
        ScheduledTaskDto savedTaskDto = (ScheduledTaskDto)this.scheduledTaskRepository.save((Object)ScheduledTaskDto.from((ScheduledTask)task));
        List savedJobDtos = Lists.newArrayList((Iterable)this.scheduledJobRepository.saveAll((Iterable)task.getScheduledJobCollection().getScheduledJobs().stream().map(job -> ScheduledJobDto.from((ScheduledJob)job, (UUID)task.getId())).collect(Collectors.toList())));
        ScheduledTask savedTask = savedTaskDto.toData();
        savedTask.setScheduledJobCollection(new ScheduledJobCollection(savedJobDtos.stream().map(ScheduledJobDto::toData).collect(Collectors.toList())));
        return savedTask;
    }

    public void remove(UUID id) {
        this.scheduledTaskRepository.deleteById((Object)id);
        this.scheduledJobRepository.removeJobsByTaskId(id);
    }

    public void removeAll(TenantId tenantId) {
        this.scheduledTaskRepository.removeAllByTenantId(tenantId.getId());
        this.scheduledJobRepository.removeAllJobsByTenantId(tenantId.getId());
    }

    private void loadJobsForGivenTasks(List<ScheduledTask> tasks) {
        Set taskIdSet = tasks.stream().map(ScheduledTask::getId).collect(Collectors.toSet());
        Map<UUID, List<ScheduledJobDto>> taskToJobListMap = this.scheduledJobRepository.getJobListByTaskIdSet(taskIdSet).stream().collect(Collectors.groupingBy(ScheduledJobDto::getTaskId));
        for (ScheduledTask task : tasks) {
            List jobs = taskToJobListMap.computeIfAbsent(task.getId(), i -> new ArrayList()).stream().map(ScheduledJobDto::toData).collect(Collectors.toList());
            task.getScheduledJobCollection().getScheduledJobs().addAll(jobs);
        }
    }
}

