/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.scheduledtask;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.scheduledtask.ScheduledJobDto;

@Repository
public interface ScheduledJobRepository
extends CrudRepository<ScheduledJobDto, UUID> {
    @Query(value="select sj from ScheduledJobDto sj where sj.taskId =:taskId")
    public List<ScheduledJobDto> getJobListByTaskId(@Param(value="taskId") UUID var1);

    @Modifying
    @Query(value="delete from ScheduledJobDto sj where sj.taskId =:taskId")
    public void removeJobsByTaskId(@Param(value="taskId") UUID var1);

    @Query(value="select sj from ScheduledJobDto sj where coalesce(:taskIds, null) is null or sj.taskId in (:taskIds)")
    public List<ScheduledJobDto> getJobListByTaskIdSet(@Param(value="taskIds") Set<UUID> var1);

    @Modifying
    @Query(value="delete from ScheduledJobDto sj where sj.taskId in (select st.id from ScheduledTaskDto st where st.tenantId = :tenantId)")
    public void removeAllJobsByTenantId(@Param(value="tenantId") UUID var1);
}

