/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.scheduledtask;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.GenericGenerator;
import org.thingsboard.trendz.dao.scheduledtask.ScheduledJobDto;
import org.thingsboard.trendz.service.scheduledtask.ScheduledJob;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="scheduled_job")
public class ScheduledJobDto {
    @Transient
    private static final ObjectMapper mapper = new ObjectMapper();
    @Id
    @GenericGenerator(name="timestampUuidGenerator", strategy="org.thingsboard.trendz.dao.sql.TimeStampUUIDGenerator")
    @GeneratedValue(generator="timestampUuidGenerator")
    @Column(name="id")
    private UUID id;
    @Column(name="task_id")
    private UUID taskId;
    @Column(name="json_data")
    private String jsonData;

    public ScheduledJob toData() {
        try {
            ScheduledJob job = (ScheduledJob)mapper.readValue(this.jsonData, ScheduledJob.class);
            return job;
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not deserialize Scheduled Job from DB: " + this.id + "  json: " + this.jsonData, e);
        }
    }

    public static ScheduledJobDto from(ScheduledJob entity, UUID taskId) {
        String jsonData;
        try {
            jsonData = mapper.writeValueAsString((Object)entity);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Could not serialize Scheduled Task: " + entity, e);
        }
        return ScheduledJobDto.builder().id(entity.getId()).taskId(taskId).jsonData(jsonData).build();
    }

    public static ScheduledJobDtoBuilder builder() {
        return new ScheduledJobDtoBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getTaskId() {
        return this.taskId;
    }

    public String getJsonData() {
        return this.jsonData;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setTaskId(UUID taskId) {
        this.taskId = taskId;
    }

    public void setJsonData(String jsonData) {
        this.jsonData = jsonData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScheduledJobDto)) {
            return false;
        }
        ScheduledJobDto other = (ScheduledJobDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$taskId = this.getTaskId();
        UUID other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !((Object)this$taskId).equals(other$taskId)) {
            return false;
        }
        String this$jsonData = this.getJsonData();
        String other$jsonData = other.getJsonData();
        return !(this$jsonData == null ? other$jsonData != null : !this$jsonData.equals(other$jsonData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScheduledJobDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : ((Object)$taskId).hashCode());
        String $jsonData = this.getJsonData();
        result = result * 59 + ($jsonData == null ? 43 : $jsonData.hashCode());
        return result;
    }

    public String toString() {
        return "ScheduledJobDto(id=" + this.getId() + ", taskId=" + this.getTaskId() + ", jsonData=" + this.getJsonData() + ")";
    }

    public ScheduledJobDto() {
    }

    public ScheduledJobDto(UUID id, UUID taskId, String jsonData) {
        this.id = id;
        this.taskId = taskId;
        this.jsonData = jsonData;
    }
}

