/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.ml;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.dao.ml.TaskRepository;
import org.thingsboard.trendz.dao.sql.ProgressStepRepository;
import org.thingsboard.trendz.dao.sql.TaskDto;
import org.thingsboard.trendz.dao.sql.TaskProgressDto;
import org.thingsboard.trendz.dao.sql.TaskProgressRepository;
import org.thingsboard.trendz.task.Task;
import org.thingsboard.trendz.task.TaskStatus;

@Component
@Transactional
public class TaskDao {
    private static final Logger log = LoggerFactory.getLogger(TaskDao.class);
    @Autowired
    private TaskRepository taskRepository;
    @Autowired
    private TaskProgressRepository taskProgressRepository;
    @Autowired
    private ProgressStepRepository progressStepRepository;

    public Task save(Task task) {
        log.trace("Trying to save task with id = {}", (Object)task.getId());
        long startTime = System.currentTimeMillis();
        Task savedTask = ((TaskDto)this.taskRepository.save((Object)TaskDto.from((Task)task))).toData();
        long endTime = System.currentTimeMillis();
        log.debug("Task has been saved with id = {}, time = {}", (Object)savedTask.getId(), (Object)(endTime - startTime));
        return savedTask;
    }

    public Task findById(UUID id) {
        log.trace("Trying to find task with id = {}", (Object)id);
        long startTime = System.currentTimeMillis();
        Task result = this.taskRepository.findById((Object)id).map(TaskDto::toData).orElse(null);
        long endTime = System.currentTimeMillis();
        if (result == null) {
            log.debug("Task is not found with id = {}, time = {}", (Object)id, (Object)(endTime - startTime));
        } else {
            log.debug("Task has been found with id = {}, time = {}", (Object)result.getId(), (Object)(endTime - startTime));
        }
        return result;
    }

    public void delete(UUID id) {
        log.trace("Trying to delete task with id = {}", (Object)id);
        long startTime = System.currentTimeMillis();
        this.taskRepository.deleteById((Object)id);
        long endTime = System.currentTimeMillis();
        log.debug("Task has been delete with id = {}, time = {}", (Object)id, (Object)(endTime - startTime));
    }

    public List<Task> findModelTasks(UUID modelId) {
        log.trace("Trying to find List of Tasks with modelId = {}", (Object)modelId);
        long startTime = System.currentTimeMillis();
        List<Task> tasks = this.taskRepository.findByModelId(modelId).stream().map(TaskDto::toData).collect(Collectors.toList());
        long endTime = System.currentTimeMillis();
        log.debug("{} tasks has been found with modelId = {}, time = {}", new Object[]{tasks.size(), modelId, endTime - startTime});
        return tasks;
    }

    public void removeModelTask(UUID modelId) {
        log.trace("Trying to remove List of Tasks with modelId = {}", (Object)modelId);
        long startTime = System.currentTimeMillis();
        List modelTasks = this.taskRepository.findByModelId(modelId);
        Set taskProgressIds = modelTasks.stream().map(TaskDto::getProgress).map(TaskProgressDto::getId).collect(Collectors.toSet());
        this.taskRepository.removeByModelId(modelId);
        if (!taskProgressIds.isEmpty()) {
            this.progressStepRepository.removeAllByTaskProgressIds(taskProgressIds);
            this.taskProgressRepository.removeAllByIds(taskProgressIds);
        }
        long endTime = System.currentTimeMillis();
        log.debug("Tasks has been remove with modelId = {}, time = {}", (Object)modelId, (Object)(endTime - startTime));
    }

    public List<Task> findTasksInStatus(TaskStatus status) {
        log.trace("Trying to find List of Tasks with status = {}", (Object)status);
        long startTime = System.currentTimeMillis();
        List<Task> tasks = this.taskRepository.findTasksInStatus(status).stream().map(TaskDto::toData).collect(Collectors.toList());
        long endTime = System.currentTimeMillis();
        log.debug("{} Tasks found with status = {}, time = {}", new Object[]{tasks.size(), status, endTime - startTime});
        return tasks;
    }
}

