/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.ml;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.dao.ml.ClusterExampleRepository;
import org.thingsboard.trendz.dao.ml.ClusterInfoRepository;
import org.thingsboard.trendz.dao.ml.ModelRepository;
import org.thingsboard.trendz.dao.ml.ScoredPointCentroidRepository;
import org.thingsboard.trendz.dao.ml.ScoredPointClusterRepository;
import org.thingsboard.trendz.dao.ml.ScoredPointHistogramRepository;
import org.thingsboard.trendz.dao.sql.ClusterInfoDto;
import org.thingsboard.trendz.dao.sql.ClusterModelDto;
import org.thingsboard.trendz.dao.sql.ScoredPointCentroidDto;
import org.thingsboard.trendz.dao.sql.ScoredPointClusterDto;
import org.thingsboard.trendz.dao.sql.ScoredPointHistogramDto;
import org.thingsboard.trendz.dao.sql.TimeStampUUIDGenerator;
import org.thingsboard.trendz.ml.AnomalyService;
import org.thingsboard.trendz.ml.domain.ClusterInfo;
import org.thingsboard.trendz.ml.domain.ClusterModel;
import org.thingsboard.trendz.ml.domain.Model;
import org.thingsboard.trendz.ml.domain.ScoredPoint;
import org.thingsboard.trendz.task.TaskService;

@Component
@Transactional
public class ModelDao {
    private static final Logger log = LoggerFactory.getLogger(ModelDao.class);
    @Autowired
    private ModelRepository modelRepository;
    @Autowired
    private ClusterInfoRepository clusterInfoRepository;
    @Autowired
    private ClusterExampleRepository clusterExampleRepository;
    @Autowired
    private ScoredPointCentroidRepository scoredPointCentroidRepository;
    @Autowired
    private ScoredPointClusterRepository scoredPointClusterRepository;
    @Autowired
    private ScoredPointHistogramRepository scoredPointHistogramRepository;
    @Autowired
    private TaskService taskService;
    @Autowired
    private AnomalyService anomalyService;

    public Model findById(UUID id) {
        log.debug("Trying to find model with id = {}", (Object)id);
        long startTime = System.currentTimeMillis();
        ClusterModel model = this.modelRepository.findById((Object)id).map(ClusterModelDto::toData).orElse(null);
        if (model != null) {
            this.loadScoredPointsForModel(model);
        }
        long endTime = System.currentTimeMillis();
        log.debug("Model has been found, id = {}, time = {}", (Object)id, (Object)(endTime - startTime));
        return model;
    }

    public void delete(UUID id, boolean isRemoveForRewriting) {
        log.debug("Trying to delete model with id = {}", (Object)id);
        long startTime = System.currentTimeMillis();
        this.modelRepository.findById((Object)id).ifPresent(modelDto -> {
            Set clusterInfoIds;
            if (!isRemoveForRewriting) {
                this.taskService.removeTaskByModelId(modelDto.getId());
                this.anomalyService.removeByModelId(modelDto.getId());
            }
            if (modelDto.getClusters() != null && !(clusterInfoIds = modelDto.getClusters().stream().map(ClusterInfoDto::getId).collect(Collectors.toSet())).isEmpty()) {
                this.scoredPointCentroidRepository.deleteByClusterInfoIds(clusterInfoIds);
                this.scoredPointHistogramRepository.deleteByClusterInfoIds(clusterInfoIds);
                Set clusterExampleIds = this.clusterExampleRepository.getIdsByClusterInfoIds(clusterInfoIds);
                if (!clusterExampleIds.isEmpty()) {
                    this.scoredPointClusterRepository.deleteByClusterExampleIds(clusterExampleIds);
                }
            }
            this.modelRepository.deleteById((Object)id);
        });
        long endTime = System.currentTimeMillis();
        log.debug("Model has been deleted, id = {}, time = {}", (Object)id, (Object)(endTime - startTime));
    }

    public List<Model> getAll(UUID tenantId) {
        log.debug("Trying to find all models, by tenant id = {}", (Object)tenantId);
        long startTime = System.currentTimeMillis();
        List<Model> models = this.modelRepository.findAllByTenantId(tenantId).stream().map(ClusterModelDto::toData).peek(arg_0 -> this.loadScoredPointsForModel(arg_0)).collect(Collectors.toList());
        long endTime = System.currentTimeMillis();
        log.debug("All models have been loaded, count = {}, time = {}", (Object)models.size(), (Object)(endTime - startTime));
        return models;
    }

    public Model save(Model model) {
        log.debug("Trying to save model");
        long startTime = System.currentTimeMillis();
        if (model instanceof ClusterModel) {
            ClusterModel clusterModel = (ClusterModel)model;
            clusterModel.getProperties().setId(TimeStampUUIDGenerator.generateId());
            ArrayList centroidDtos = new ArrayList();
            ArrayList histogramDtos = new ArrayList();
            ArrayList clusterExamplePointsDtos = new ArrayList();
            if (clusterModel.getClusters() != null) {
                clusterModel.getClusters().stream().peek(clusterInfo -> clusterInfo.setId(TimeStampUUIDGenerator.generateId())).forEach(clusterInfo -> {
                    centroidDtos.addAll(this.getCentroidDtos(clusterInfo.getCentroid(), clusterInfo.getId()));
                    histogramDtos.addAll(this.getHistogramDtos(clusterInfo.getHistogram(), clusterInfo.getId()));
                    clusterInfo.getClusterExamples().keySet().forEach(clusterExampleId -> clusterExamplePointsDtos.addAll(this.getClusterExamplePointsDtos((List)clusterInfo.getClusterExamples().get(clusterExampleId), clusterExampleId)));
                });
            }
            ClusterModel savedModel = ((ClusterModelDto)this.modelRepository.save((Object)ClusterModelDto.from((ClusterModel)clusterModel))).toData();
            ArrayList savedCentroids = Lists.newArrayList((Iterable)this.scoredPointCentroidRepository.saveAll(centroidDtos));
            ArrayList savedHistogram = Lists.newArrayList((Iterable)this.scoredPointHistogramRepository.saveAll(histogramDtos));
            ArrayList savedClusterExamplePoints = Lists.newArrayList((Iterable)this.scoredPointClusterRepository.saveAll(clusterExamplePointsDtos));
            if (savedModel.getClusters() != null) {
                savedModel.getClusters().stream().peek(clusterInfo -> clusterInfo.setCentroid(this.getCentroidPointPojos(savedCentroids, clusterInfo.getId()))).peek(clusterInfo -> clusterInfo.setHistogram(this.getHistogramPointPojos(savedHistogram, clusterInfo.getId()))).map(ClusterInfo::getClusterExamples).forEach(clusterExampleMap -> clusterExampleMap.keySet().forEach(clusterExampleId -> clusterExampleMap.put(clusterExampleId, this.getClusterExamplePointPojos(savedClusterExamplePoints, clusterExampleId))));
            }
            long endTime = System.currentTimeMillis();
            log.debug("Model {} saved in {} ms", (Object)savedModel.getId(), (Object)(endTime - startTime));
            return savedModel;
        }
        throw new IllegalArgumentException("Model type is not supported, class: " + model.getClass());
    }

    private void loadScoredPointsForModel(ClusterModel model) {
        Set clusterInfoIds = model.getClusters().stream().map(ClusterInfo::getId).collect(Collectors.toSet());
        Set clusterExampleIds = model.getClusters().stream().map(ClusterInfo::getClusterExamples).map(Map::keySet).flatMap(Collection::stream).collect(Collectors.toSet());
        List loadedCentroids = this.loadCentroidByClusterInfoId(clusterInfoIds);
        List loadedHistograms = this.loadHistogramByClusterInfoId(clusterInfoIds);
        List loadedClusterExamplePoints = this.loadScoredPointsByClusterExampleId(clusterExampleIds);
        model.getClusters().forEach(clusterInfo -> {
            clusterInfo.setCentroid(loadedCentroids.stream().filter(centroid -> centroid.getClusterInfoId().equals(clusterInfo.getId())).map(ScoredPointCentroidDto::toData).sorted().collect(Collectors.toList()));
            clusterInfo.setHistogram(loadedHistograms.stream().filter(histogram -> histogram.getClusterInfoId().equals(clusterInfo.getId())).map(ScoredPointHistogramDto::toData).sorted().collect(Collectors.toList()));
            clusterInfo.getClusterExamples().keySet().forEach(clusterExampleId -> clusterInfo.getClusterExamples().put(clusterExampleId, loadedClusterExamplePoints.stream().filter(examplePoint -> examplePoint.getClusterExampleId().equals(clusterExampleId)).map(ScoredPointClusterDto::toData).sorted().collect(Collectors.toList())));
        });
    }

    private List<ScoredPointCentroidDto> loadCentroidByClusterInfoId(Set<UUID> clusterInfoIds) {
        if (clusterInfoIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.scoredPointCentroidRepository.findByClusterInfoIds(clusterInfoIds);
    }

    private List<ScoredPointHistogramDto> loadHistogramByClusterInfoId(Set<UUID> clusterInfoIds) {
        if (clusterInfoIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.scoredPointHistogramRepository.findByClusterInfoIds(clusterInfoIds);
    }

    private List<ScoredPointClusterDto> loadScoredPointsByClusterExampleId(Set<UUID> clusterExampleIds) {
        if (clusterExampleIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.scoredPointClusterRepository.findByClusterExampleIds(clusterExampleIds);
    }

    private List<ScoredPointCentroidDto> getCentroidDtos(List<ScoredPoint> centroids, UUID clusterInfoId) {
        return centroids.stream().map(scoredPoint -> ScoredPointCentroidDto.from((ScoredPoint)scoredPoint, (UUID)clusterInfoId)).collect(Collectors.toList());
    }

    private List<ScoredPointHistogramDto> getHistogramDtos(List<ScoredPoint> histograms, UUID clusterInfoId) {
        return histograms.stream().map(scoredPoint -> ScoredPointHistogramDto.from((ScoredPoint)scoredPoint, (UUID)clusterInfoId)).collect(Collectors.toList());
    }

    private List<ScoredPointClusterDto> getClusterExamplePointsDtos(List<ScoredPoint> clusterExamplePoints, UUID clusterExampleId) {
        return clusterExamplePoints.stream().map(scoredPoint -> ScoredPointClusterDto.from((ScoredPoint)scoredPoint, (UUID)clusterExampleId)).collect(Collectors.toList());
    }

    private List<ScoredPoint> getCentroidPointPojos(List<ScoredPointCentroidDto> allCentroidPointDtos, UUID clusterInfoId) {
        return allCentroidPointDtos.stream().filter(centroid -> centroid.getClusterInfoId().equals(clusterInfoId)).map(ScoredPointCentroidDto::toData).sorted().collect(Collectors.toList());
    }

    private List<ScoredPoint> getHistogramPointPojos(List<ScoredPointHistogramDto> allHistogramPointDtos, UUID clusterInfoId) {
        return allHistogramPointDtos.stream().filter(histogram -> histogram.getClusterInfoId().equals(clusterInfoId)).map(ScoredPointHistogramDto::toData).sorted().collect(Collectors.toList());
    }

    private List<ScoredPoint> getClusterExamplePointPojos(List<ScoredPointClusterDto> allClusterExamplePointDtos, UUID clusterExampleId) {
        return allClusterExamplePointDtos.stream().filter(clusterExamplePoint -> clusterExamplePoint.getClusterExampleId().equals(clusterExampleId)).map(ScoredPointClusterDto::toData).sorted().collect(Collectors.toList());
    }
}

