/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.ml;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.sql.CachedTelemetryPointDto;

@Repository
public interface CachedTelemetryPointRepository
extends CrudRepository<CachedTelemetryPointDto, UUID> {
    @Query(value="select ctp from CachedTelemetryPointDto ctp where coalesce(:cachedTelemetryIds, null) is null or ctp.cachedTelemetryId in (:cachedTelemetryIds)")
    public List<CachedTelemetryPointDto> findAllByCachedTelemetryIds(@Param(value="cachedTelemetryIds") Set<UUID> var1);

    @Modifying
    @Query(value="delete from CachedTelemetryPointDto ctp where coalesce(:cachedTelemetryIds, null) is null or ctp.cachedTelemetryId in (:cachedTelemetryIds)")
    public void deleteAllByCachedTelemetryIds(@Param(value="cachedTelemetryIds") Set<UUID> var1);

    @Modifying
    @Query(value="delete from CachedTelemetryPointDto ctp")
    public void deleteAll();

    @Query(value="select count(1) from CachedTelemetryPointDto ctp")
    public long computePointCount();

    @Query(value="select count(1) from CachedTelemetryPointDto ctp where ctp.cachedTelemetryId = :cachedTelemetryId")
    public long computePointCountOfCachedTelemetry(@Param(value="cachedTelemetryId") UUID var1);
}

