/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.ml;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.hibernate.exception.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.dao.ml.CachedTelemetryDao;
import org.thingsboard.trendz.domain.cache.CachedTelemetry;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import reactor.core.publisher.Mono;

@Service
public class CachedTelemetryDaoAsync {
    private static final Logger log = LoggerFactory.getLogger(CachedTelemetryDaoAsync.class);
    @Autowired
    private CachedTelemetryDao cachedTelemetryDao;
    private final ExecutorService executorService = Executors.newFixedThreadPool(20);

    public Mono<List<CachedTelemetry>> findAllCompatibleCachedTelemetriesAsync(Set<UUID> itemIds, long startTs, long endTs, FieldAggregation fieldAggregation, DateAggregationType equalDateAggregationType, UUID businessEntityFieldId, String function) {
        return Mono.fromFuture(CompletableFuture.supplyAsync(() -> this.cachedTelemetryDao.findAllCompatibleCachedTelemetries(itemIds, startTs, endTs, fieldAggregation, equalDateAggregationType, businessEntityFieldId, function), this.executorService));
    }

    public Mono<Boolean> saveOneAndRemoveListAsync(CachedTelemetry cachedTelemetry, List<CachedTelemetry> cachedTelemetryList) {
        return Mono.fromFuture(CompletableFuture.supplyAsync(() -> {
            try {
                this.cachedTelemetryDao.saveOneAndRemoveList(cachedTelemetry, cachedTelemetryList);
            }
            catch (DataIntegrityViolationException e) {
                if (e.getCause() instanceof ConstraintViolationException) {
                    log.warn("There is cache telemetry header saving error by violating unique constrain (async saving same data)");
                }
                throw new IllegalStateException("There is unexpected exception:" + (Object)((Object)e));
            }
            return true;
        }, this.executorService));
    }

    public Mono<Boolean> saveCachedTelemetryAsync(CachedTelemetry cachedTelemetry) {
        return Mono.fromFuture(CompletableFuture.supplyAsync(() -> {
            try {
                this.cachedTelemetryDao.saveCachedTelemetry(cachedTelemetry);
            }
            catch (DataIntegrityViolationException e) {
                if (e.getCause() instanceof ConstraintViolationException) {
                    log.warn("There is cache telemetry header saving error by violating unique constrain (async saving same data)");
                }
                throw new IllegalStateException("There is unexpected exception:" + (Object)((Object)e));
            }
            return true;
        }, this.executorService));
    }

    public Mono<Boolean> removeAllByTenantIdAsync(TenantId tenantId) {
        return Mono.fromFuture(CompletableFuture.supplyAsync(() -> {
            this.cachedTelemetryDao.removeAllByTenantId(tenantId);
            return true;
        }, this.executorService));
    }

    public Mono<Boolean> removeAllCacheAsync() {
        return Mono.fromFuture(CompletableFuture.supplyAsync(() -> {
            this.cachedTelemetryDao.removeAllCache();
            return true;
        }, this.executorService));
    }
}

