/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.ml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.dao.ml.CachedTelemetryPointRepository;
import org.thingsboard.trendz.dao.ml.CachedTelemetryRepository;
import org.thingsboard.trendz.dao.sql.CachedTelemetryDto;
import org.thingsboard.trendz.dao.sql.CachedTelemetryPointDto;
import org.thingsboard.trendz.domain.cache.CachedTelemetry;
import org.thingsboard.trendz.domain.cache.CachedTelemetryPoint;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.service.definition.BusinessEntityService;

@Service
@Transactional
public class CachedTelemetryDao {
    private static final Logger log = LoggerFactory.getLogger(CachedTelemetryDao.class);
    @Autowired
    private BusinessEntityService businessEntityService;
    @Autowired
    private CachedTelemetryRepository cachedTelemetryRepository;
    @Autowired
    private CachedTelemetryPointRepository cachedTelemetryPointRepository;

    public List<CachedTelemetry> findAllCompatibleCachedTelemetries(Set<UUID> itemIds, long startTs, long endTs, FieldAggregation fieldAggregation, DateAggregationType equalDateAggregationType, UUID businessEntityFieldId, String function) {
        long logStartTs = System.currentTimeMillis();
        List loadedCacheTelemetryDtos = this.loadCompatibleTelemetryHeaders(itemIds, startTs, endTs, fieldAggregation, equalDateAggregationType, businessEntityFieldId, function);
        List<CachedTelemetry> loadedCacheTelemetries = loadedCacheTelemetryDtos.stream().map(CachedTelemetryDto::toData).collect(Collectors.toList());
        long logHeadersLoadedTs = System.currentTimeMillis();
        if (!loadedCacheTelemetries.isEmpty()) {
            this.loadCompatibleTelemetryPoints(loadedCacheTelemetries);
        }
        long logEndTs = System.currentTimeMillis();
        long telemetryCount = loadedCacheTelemetries.size();
        long telemetryPointCount = loadedCacheTelemetries.stream().map(CachedTelemetry::getPoints).mapToLong(List::size).sum();
        log.debug("CachedTelemetryDao: find compatible caches, loading headers time = {} ms, loading points time = {} ms, count = {}, pointsCount = {}", new Object[]{logHeadersLoadedTs - logStartTs, logEndTs - logHeadersLoadedTs, telemetryCount, telemetryPointCount});
        return loadedCacheTelemetries;
    }

    public void saveOneAndRemoveList(CachedTelemetry cachedTelemetry, List<CachedTelemetry> cachedTelemetryList) {
        this.saveCachedTelemetry(cachedTelemetry);
        this.removeCachedTelemetriesList(cachedTelemetryList);
    }

    public void saveCachedTelemetry(CachedTelemetry cachedTelemetry) {
        long logStartTs = System.currentTimeMillis();
        CachedTelemetryDto savedCache = (CachedTelemetryDto)this.cachedTelemetryRepository.save((Object)CachedTelemetryDto.from((CachedTelemetry)cachedTelemetry));
        Set telemetryPointDtos = cachedTelemetry.getPoints().stream().map(point -> CachedTelemetryPointDto.from((CachedTelemetryPoint)point, (UUID)savedCache.getId(), (FieldType)cachedTelemetry.getFieldType())).collect(Collectors.toSet());
        if (!telemetryPointDtos.isEmpty()) {
            this.cachedTelemetryPointRepository.saveAll(telemetryPointDtos);
        }
        long logEndTs = System.currentTimeMillis();
        log.debug("CachedTelemetryDao: save cache, time = {} ms, pointCount = {}", (Object)(logEndTs - logStartTs), (Object)cachedTelemetry.getPoints().size());
    }

    public void removeCachedTelemetriesList(List<CachedTelemetry> cachedTelemetryList) {
        long logStartTs = System.currentTimeMillis();
        Set cachedTelemetryIds = cachedTelemetryList.stream().map(CachedTelemetry::getId).collect(Collectors.toSet());
        this.cachedTelemetryPointRepository.deleteAllByCachedTelemetryIds(cachedTelemetryIds);
        this.cachedTelemetryRepository.deleteAll((Iterable)cachedTelemetryList.stream().map(CachedTelemetryDto::from).collect(Collectors.toSet()));
        long logEndTs = System.currentTimeMillis();
        log.debug("CachedTelemetryDao: remove cache list, time = {} ms, count = {}, pointCount = {}", new Object[]{logEndTs - logStartTs, cachedTelemetryList.size(), cachedTelemetryList.stream().map(CachedTelemetry::getPoints).mapToLong(List::size).sum()});
    }

    public void removeAllByTenantId(TenantId tenantId) {
        long logStartTs = System.currentTimeMillis();
        Set cachedTelemetryIds = this.cachedTelemetryRepository.findIdsByTenantId(tenantId.getId());
        this.cachedTelemetryRepository.deleteByTenantId(tenantId.getId());
        this.cachedTelemetryPointRepository.deleteAllByCachedTelemetryIds(cachedTelemetryIds);
        long logEndTs = System.currentTimeMillis();
        log.debug("CachedTelemetryDao: removing all caches by tenant id, time = {} ms", (Object)(logEndTs - logStartTs));
    }

    public void removeAllCache() {
        long logStartTs = System.currentTimeMillis();
        this.cachedTelemetryPointRepository.deleteAll();
        this.cachedTelemetryRepository.deleteAll();
        long logEndTs = System.currentTimeMillis();
        log.debug("CachedTelemetryDao: removing all caches, time = {} ms", (Object)(logEndTs - logStartTs));
    }

    public long computeCacheTelemetryCount() {
        return this.cachedTelemetryRepository.computeCacheTelemetryCount();
    }

    public long computePointCount() {
        return this.cachedTelemetryPointRepository.computePointCount();
    }

    private List<CachedTelemetryDto> loadCompatibleTelemetryHeaders(Set<UUID> itemIds, long startTs, long endTs, FieldAggregation fieldAggregation, DateAggregationType equalDateAggregationType, UUID businessEntityFieldId, String function) {
        if (function != null) {
            return this.cachedTelemetryRepository.findAllCompatibleByCalculatedTelemetry(itemIds, startTs, endTs, fieldAggregation, equalDateAggregationType, function);
        }
        return this.cachedTelemetryRepository.findAllCompatibleBySingleTelemetry(itemIds, startTs, endTs, fieldAggregation, equalDateAggregationType, businessEntityFieldId);
    }

    private void loadCompatibleTelemetryPoints(List<CachedTelemetry> loadedCacheTelemetries) {
        Set loadedCacheTelemetryIds = loadedCacheTelemetries.stream().map(CachedTelemetry::getId).collect(Collectors.toSet());
        Map<UUID, List<CachedTelemetryPointDto>> telemetryIdToPoints = this.cachedTelemetryPointRepository.findAllByCachedTelemetryIds(loadedCacheTelemetryIds).stream().collect(Collectors.groupingBy(CachedTelemetryPointDto::getCachedTelemetryId));
        for (CachedTelemetry telemetry : loadedCacheTelemetries) {
            List cachedTelemetryPoints = telemetryIdToPoints.computeIfAbsent(telemetry.getId(), i -> new ArrayList()).stream().map(CachedTelemetryPointDto::toData).collect(Collectors.toList());
            telemetry.setPoints(cachedTelemetryPoints);
        }
    }
}

