/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.ml;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.sql.AnomalyDto;

@Repository
public interface AnomalyRepository
extends CrudRepository<AnomalyDto, UUID> {
    @Query(value="select a from AnomalyDto a where (coalesce(:itemIds, null) is null or a.itemId in (:itemIds)) and (coalesce(:modelIds, null) is null or a.modelId in (:modelIds)) and (coalesce(:taskIds, null) is null or a.taskId in (:taskIds)) and (coalesce(:startTs, null) is null or a.endTs >= (:startTs)) and (coalesce(:endTs, null) is null or a.startTs <= (:endTs)) and (coalesce(:minScore, null) is null or a.score >= (:minScore))")
    public List<AnomalyDto> find(@Param(value="itemIds") Set<UUID> var1, @Param(value="modelIds") Set<UUID> var2, @Param(value="taskIds") Set<UUID> var3, @Param(value="startTs") Long var4, @Param(value="endTs") Long var5, @Param(value="minScore") Double var6);

    @Query(value="select a.id from AnomalyDto a where a.modelId = :modelId")
    public Set<UUID> getAllIdsByModelId(@Param(value="modelId") UUID var1);

    @Modifying
    @Query(value="delete from AnomalyDto a where a.modelId = :modelId")
    public void deleteByModelId(@Param(value="modelId") UUID var1);

    @Query(value="select a.id from AnomalyDto a where a.taskId = :taskId")
    public Set<UUID> getAllIdsByTaskId(@Param(value="taskId") UUID var1);

    @Modifying
    @Query(value="delete from AnomalyDto a where a.taskId = :taskId")
    public void deleteByTaskId(@Param(value="taskId") UUID var1);
}

