/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.ml;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.dao.ml.AnomalyRepository;
import org.thingsboard.trendz.dao.ml.ScoredPointAnomalyRepository;
import org.thingsboard.trendz.dao.sql.AnomalyDto;
import org.thingsboard.trendz.dao.sql.ScoredPointAnomalyDto;
import org.thingsboard.trendz.dao.sql.TimeStampUUIDGenerator;
import org.thingsboard.trendz.ml.anomaly.AnomalyFilter;
import org.thingsboard.trendz.ml.domain.Anomaly;
import org.thingsboard.trendz.ml.domain.ScoredPoint;

@Component
@Transactional
public class AnomalyDao {
    private static final Logger log = LoggerFactory.getLogger(AnomalyDao.class);
    @Autowired
    private AnomalyRepository anomalyRepository;
    @Autowired
    private ScoredPointAnomalyRepository scoredPointAnomalyRepository;

    public List<Anomaly> find(AnomalyFilter filter) {
        log.debug("Find anomalies by filter {}", (Object)filter);
        long startTime = System.currentTimeMillis();
        List<Anomaly> anomalies = this.anomalyRepository.find(filter.getItemIds(), filter.getModelIds(), filter.getTaskIds(), filter.getStartTs(), filter.getEndTs(), filter.getMinScore()).stream().map(AnomalyDto::toData).collect(Collectors.toList());
        this.loadAnomalyPoints(anomalies);
        long endTime = System.currentTimeMillis();
        log.debug("{} Anomalies has been found in {} ms", (Object)anomalies.size(), (Object)(endTime - startTime));
        return anomalies;
    }

    public void save(List<Anomaly> anomalies) {
        log.debug("Save {} anomalies", (Object)anomalies.size());
        anomalies.forEach(anomaly -> anomaly.setId(TimeStampUUIDGenerator.generateId()));
        long startTime = System.currentTimeMillis();
        this.anomalyRepository.saveAll((Iterable)anomalies.stream().map(AnomalyDto::from).collect(Collectors.toList()));
        long afterAnomalySavingTime = System.currentTimeMillis();
        List pointsDTOs = anomalies.stream().flatMap(anomaly -> anomaly.getData().stream().map(scoredPoint -> ScoredPointAnomalyDto.from((ScoredPoint)scoredPoint, (UUID)anomaly.getId()))).collect(Collectors.toList());
        this.scoredPointAnomalyRepository.saveAll(pointsDTOs);
        long afterAnomalyScorePointsSavingTime = System.currentTimeMillis();
        log.debug("Anomalies has been saved with anomaliesCNT = {}, time = {}, pointsCnt {} time = {}", new Object[]{anomalies.size(), afterAnomalySavingTime - startTime, pointsDTOs.size(), afterAnomalyScorePointsSavingTime - afterAnomalySavingTime});
    }

    public void removeByModelId(UUID modelId) {
        log.debug("Delete anomalies for modelId {}", (Object)modelId);
        long startTime = System.currentTimeMillis();
        Set anomalyIds = this.anomalyRepository.getAllIdsByModelId(modelId);
        this.scoredPointAnomalyRepository.deleteByAnomalyIds(anomalyIds);
        this.anomalyRepository.deleteByModelId(modelId);
        long endTime = System.currentTimeMillis();
        log.debug("{} Anomalies deleted for modelId = {} in {} ms", new Object[]{anomalyIds.size(), modelId, endTime - startTime});
    }

    public void removeByTaskId(UUID taskId) {
        log.debug("Delete anomalies for taskId {}", (Object)taskId);
        long startTime = System.currentTimeMillis();
        Set anomalyIds = this.anomalyRepository.getAllIdsByTaskId(taskId);
        this.scoredPointAnomalyRepository.deleteByAnomalyIds(anomalyIds);
        this.anomalyRepository.deleteByTaskId(taskId);
        long endTime = System.currentTimeMillis();
        log.debug("{} Anomalies deleted for taskId {} in {} ms", new Object[]{anomalyIds.size(), taskId, endTime - startTime});
    }

    private void loadAnomalyPoints(List<Anomaly> anomalies) {
        if (anomalies.isEmpty()) {
            return;
        }
        Set anomalyIds = anomalies.stream().map(Anomaly::getId).collect(Collectors.toSet());
        Map<UUID, List<ScoredPointAnomalyDto>> anomalyIdToDataMap = this.scoredPointAnomalyRepository.findByAnomalyIds(anomalyIds).stream().collect(Collectors.groupingBy(ScoredPointAnomalyDto::getAnomalyId));
        anomalies.forEach(anomaly -> anomaly.setData(((List)anomalyIdToDataMap.get(anomaly.getId())).stream().map(ScoredPointAnomalyDto::toData).sorted().collect(Collectors.toList())));
    }
}

